/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.jbpm.formModeler.service.LocaleManager;
import org.jbpm.formModeler.service.error.ApplicationError;
import org.jbpm.formModeler.service.error.BusinessError;
import org.jbpm.formModeler.service.error.ErrorManager;

public class ErrorReport {
    protected Date date = new Date();
    protected String id = null;
    protected Throwable exception = null;
    protected static transient DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String printContext(int indent) {
        StringBuffer buf = new StringBuffer();
        ErrorReport.appendIndent(buf, indent);
        ErrorReport.appendIndent(buf, indent);
        buf.append("Error id='").append(this.id).append("'\n");
        ErrorReport.appendIndent(buf, indent);
        buf.append("Error date='").append(dateFormat.format(this.date)).append("'\n");
        ErrorReport.appendIndent(buf, indent);
        buf.append("\r\n");
        ErrorReport.appendIndent(buf, indent);
        buf.append(this.printExceptionTrace());
        return buf.toString();
    }

    public String printExceptionTrace() {
        StringWriter sw = new StringWriter();
        ErrorManager.lookup().getRootCause(this.exception).printStackTrace(new PrintWriter(sw));
        return sw.getBuffer().toString();
    }

    public static void appendIndent(StringBuffer out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.append("\t");
        }
    }

    public boolean isBusinessAppError() {
        ApplicationError appError = ErrorManager.lookup().getApplicationErrorCause(this.exception);
        return appError != null && appError instanceof BusinessError;
    }

    public boolean isTechnicalAppError() {
        ApplicationError appError = ErrorManager.lookup().getApplicationErrorCause(this.exception);
        return appError != null && appError instanceof BusinessError;
    }

    protected String getUnexpectedErrorTitle() {
        ResourceBundle i18n = ResourceBundle.getBundle("org.jbpm.formModeler.service.error.messages", LocaleManager.currentLocale());
        return i18n.getString("errorTitle");
    }

    protected String getUnexpectedErrorMessage() {
        ResourceBundle i18n = ResourceBundle.getBundle("org.jbpm.formModeler.service.error.messages", LocaleManager.currentLocale());
        return i18n.getString("errorMessage");
    }

    public String printErrorTitle() {
        ApplicationError appError = ErrorManager.lookup().getApplicationErrorCause(this.exception);
        if (this.isBusinessAppError()) {
            return ((BusinessError)appError).getTitle();
        }
        return this.getUnexpectedErrorTitle();
    }

    public String printErrorMessage() {
        ApplicationError appError = ErrorManager.lookup().getApplicationErrorCause(this.exception);
        if (appError != null) {
            return appError.getMessage();
        }
        return this.getUnexpectedErrorMessage();
    }

    public static void main(String[] args) {
        ErrorReport report = new ErrorReport();
        report.setException(new RuntimeException("ERROR"));
        report.setId(String.valueOf(System.currentTimeMillis()));
        System.out.println(report.toString());
    }
}

