/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jbpm.formModeler.service.annotation.Startable;
import org.jbpm.formModeler.service.comparator.ComparatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartableProcessor {
    protected Logger log = LoggerFactory.getLogger(StartableProcessor.class);
    @Inject
    protected Instance<Startable> startables;
    protected StartableComparator startableComparator = new StartableComparator();

    public void wakeUpStartableBeans() throws Exception {
        ArrayList<Startable> startableList = new ArrayList<Startable>();
        for (Startable startable : this.startables) {
            startableList.add(startable);
        }
        Collections.sort(startableList, this.startableComparator);
        for (Startable startable : startableList) {
            try {
                this.log.debug("Starting {} priority bean {}", (Object)startable.getPriority(), (Object)startable.getClass().getName());
                startable.start();
            }
            catch (Exception e) {
                this.log.error("Error starting bean " + startable.getClass().getName(), (Throwable)e);
            }
        }
    }

    private class StartableComparator
    implements Comparator {
        private StartableComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                Startable s1 = (Startable)o1;
                Startable s2 = (Startable)o2;
                return ComparatorUtils.compare(Integer.valueOf(s1.getPriority().getWeight()), Integer.valueOf(s2.getPriority().getWeight()), -1);
            }
            catch (ClassCastException e) {
                return 0;
            }
        }
    }
}

