/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.comparator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ComparatorUtils {
    public static int compare(Comparable o1, Comparable o2, int ordering) {
        int comp = 0;
        if (o1 == null && o2 != null) {
            comp = -1;
        } else if (o1 != null && o2 == null) {
            comp = 1;
        } else if (o1 == null && o2 == null) {
            comp = 0;
        } else {
            comp = o1.compareTo(o2);
            if (comp > 0) {
                comp = 1;
            } else if (comp < 0) {
                comp = -1;
            }
        }
        if (ordering == -1) {
            return comp * ordering;
        }
        return comp;
    }

    public static int compare(Date o1, Date o2, int ordering) {
        int comp = 0;
        if (o1 == null && o2 != null) {
            comp = -1;
        } else if (o1 != null && o2 == null) {
            comp = 1;
        } else if (o1 == null && o2 == null) {
            comp = 0;
        } else {
            long anotherTime;
            long thisTime = o1.getTime();
            int n = thisTime < (anotherTime = o2.getTime()) ? -1 : (comp = thisTime == anotherTime ? 0 : 1);
        }
        if (ordering == -1) {
            return comp * ordering;
        }
        return comp;
    }

    public static int compare(Boolean o1, Boolean o2, int ordering) {
        int comp = 0;
        comp = o1 == null && o2 != null ? -1 : (o1 != null && o2 == null ? 1 : (o1 == null && o2 == null ? 0 : (o1.booleanValue() == o2.booleanValue() ? 0 : (o1 != false ? 1 : -1))));
        if (ordering == -1) {
            return comp * ordering;
        }
        return comp;
    }

    public static boolean equals(Collection o1, Collection o2) {
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null && o2 == null) {
            return false;
        }
        if (o1.size() != o2.size()) {
            return false;
        }
        if (o1.isEmpty() && o2.isEmpty()) {
            return false;
        }
        return CollectionUtils.intersection((Collection)o1, (Collection)o2).size() == o1.size();
    }

    public static int compare(Collection o1, Collection o2, int ordering) {
        int comp = 0;
        if (o1 == null && o2 != null) {
            comp = -1;
        } else if (o1 != null && o2 == null) {
            comp = 1;
        } else if (o1 == null && o2 == null) {
            comp = 0;
        } else if (o1.size() == 0 && o2.size() > 0) {
            comp = -1;
        } else if (o1.size() > 0 && o2.size() == 0) {
            comp = 1;
        } else {
            int o1comp = 0;
            for (Object value : o1) {
                o1comp = ComparatorUtils.compare(value, o2, ordering);
                if (o1comp == 0) continue;
                if (o1comp == -1) {
                    comp = -1;
                }
                if (o1comp != 1 || comp == -1) continue;
                comp = 1;
            }
            int o2comp = 0;
            Iterator it = o2.iterator();
            while (comp == 0 && it.hasNext()) {
                Object value = it.next();
                o2comp = ComparatorUtils.compare(value, o1, ordering);
                if (o2comp == 0) continue;
                if (o2comp == -1) {
                    comp = 1;
                }
                if (o2comp != 1 || comp == -1) continue;
                comp = -1;
            }
        }
        if (ordering == -1) {
            return comp * ordering;
        }
        return comp;
    }

    public static int compare(Object obj, Collection col, int ordering) {
        int comp = 0;
        if (obj == null && col == null) {
            comp = 0;
        } else if (obj == null && col != null && col.size() > 0) {
            comp = -1;
        } else if (obj != null && (col == null || col.size() == 0)) {
            comp = 1;
        } else {
            for (Object value : col) {
                comp += ComparatorUtils.compare(obj, value, ordering);
            }
            comp = comp == col.size() ? 1 : (comp == col.size() * -1 ? -1 : 0);
        }
        if (ordering == -1) {
            return comp * ordering;
        }
        return comp;
    }

    public static int compare(Object o1, Object o2, int ordering) {
        int comp = 0;
        if (o1 == null && o2 != null) {
            comp = -1;
        } else if (o1 != null && o2 == null) {
            comp = 1;
        } else if (o1 == null && o2 == null) {
            comp = 0;
        } else {
            if (o1 instanceof Boolean && o2 instanceof Boolean) {
                return ComparatorUtils.compare((Boolean)o1, (Boolean)o2, ordering);
            }
            if (o1 instanceof Date && o2 instanceof Date) {
                return ComparatorUtils.compare((Date)o1, (Date)o2, ordering);
            }
            if (o1 instanceof Collection && o2 instanceof Collection) {
                return ComparatorUtils.compare((Collection)o1, (Collection)o2, ordering);
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ComparatorUtils.compare((Comparable)o1, (Comparable)o2, ordering);
            }
        }
        if (ordering == -1) {
            return comp * ordering;
        }
        return comp;
    }

    public static void main(String[] args) throws Exception {
        String[] stringArray = new String[]{"3", "4", "1"};
        Long[] longArray = new Long[]{new Long(3L), new Long(2L), new Long(4L)};
        Boolean[] booleanArray = new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.FALSE};
        List<String> stringList = Arrays.asList(stringArray);
        List<Long> longList = Arrays.asList(longArray);
        List<Boolean> booleanList = Arrays.asList(booleanArray);
        List<String> collection1 = Arrays.asList("A");
        List<String> collection2 = Arrays.asList("B");
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ComparatorUtils.compare(o1, o2, -1);
            }
        };
        Collections.sort(stringList, comparator);
        Collections.sort(longList, comparator);
        Collections.sort(booleanList, comparator);
        System.out.println(stringList);
        System.out.println(longList);
        System.out.println(booleanList);
        System.out.println(comparator.compare(collection1, collection2));
    }
}

