/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.dataModeler.integration;

import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.util.StringUtils;
import org.guvnor.common.services.project.model.Project;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.core.config.builders.dataHolder.DataHolderBuildConfig;
import org.jbpm.formModeler.core.config.builders.dataHolder.RangedDataHolderBuilder;
import org.jbpm.formModeler.dataModeler.model.DataModelerDataHolder;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DataModelerService
implements RangedDataHolderBuilder {
    public static final String HOLDER_TYPE_DATA_MODEL = "dataModelerEntry";
    private Logger log = LoggerFactory.getLogger(DataModelerService.class);
    @Inject
    protected org.kie.workbench.common.screens.datamodeller.service.DataModelerService dataModelerService;
    @Inject
    private BuildInfoService buildInfoService;
    @Inject
    protected KieProjectService projectService;
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;

    public Map<String, String> getHolderSources(String path) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        try {
            DataModel dataModel = this.dataModelerService.loadModel((KieProject)this.projectService.resolveProject(this.getPath(path)));
            if (dataModel != null && dataModel.getDataObjects() != null) {
                String className = "";
                for (DataObject dataObject : dataModel.getDataObjects()) {
                    className = dataObject.getClassName();
                    result.put(className, className);
                }
            }
        }
        catch (Throwable e) {
            result.put("-", "-");
        }
        return result;
    }

    public DataHolder buildDataHolder(DataHolderBuildConfig config) {
        DataModelerDataHolder dataHolder = null;
        boolean isExternal = false;
        String path = config.getAttribute("path");
        if (StringUtils.isEmpty((CharSequence)path)) {
            dataHolder = new DataModelerDataHolder(config.getHolderId(), config.getInputId(), config.getOutputId(), config.getValue(), config.getRenderColor());
            isExternal = Boolean.TRUE.equals(config.getAttribute("supportedType"));
        } else {
            Class holderClass = this.findHolderClass(config.getValue(), config.getAttribute("path"));
            if (holderClass == null) {
                return null;
            }
            DataModel dataModel = this.dataModelerService.loadModel((KieProject)this.projectService.resolveProject(this.getPath(path)));
            isExternal = dataModel.isExternal(config.getValue());
            dataHolder = new DataModelerDataHolder(config.getHolderId(), config.getInputId(), config.getOutputId(), holderClass, config.getRenderColor());
        }
        if (isExternal) {
            dataHolder.setSupportedType("className");
        }
        return dataHolder;
    }

    protected Class findHolderClass(String className, String path) {
        ClassLoader classLoader = this.getProjectClassLoader((KieProject)this.projectService.resolveProject(this.getPath(path)));
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            this.log.warn("Unable to load class '{}': {}", (Object)className, (Object)e);
            return null;
        }
    }

    public String getId() {
        return HOLDER_TYPE_DATA_MODEL;
    }

    protected org.uberfire.backend.vfs.Path getPath(String path) {
        try {
            return Paths.convert((Path)this.ioService.get(new URI(path)));
        }
        catch (Exception e) {
            this.log.error("Unable to build Path for {}': {}", (Object)path, (Object)e);
            return null;
        }
    }

    public boolean supportsPropertyType(String className, String path) {
        return this.getDataObject(className, this.getPath(path)) != null;
    }

    protected DataObject getDataObject(String className, org.uberfire.backend.vfs.Path path) {
        DataModel dataModel = this.getDataModel(path);
        DataObject result = dataModel.getDataObject(className);
        if (result == null) {
            for (DataObject externalDataObject : dataModel.getExternalClasses()) {
                if (!className.equals(externalDataObject.getClassName())) continue;
                return externalDataObject;
            }
        }
        return result;
    }

    protected DataModel getDataModel(org.uberfire.backend.vfs.Path path) {
        KieProject project = (KieProject)this.projectService.resolveProject(path);
        return this.dataModelerService.loadModel(project);
    }

    public int getPriority() {
        return 2;
    }

    public String[] getSupportedHolderTypes() {
        return new String[]{"className"};
    }

    protected ClassLoader getProjectClassLoader(KieProject project) {
        KieModule module = this.buildInfoService.getBuildInfo((Project)project).getKieModuleIgnoringErrors();
        ClassLoader classLoader = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)module).getClassLoader();
        return classLoader;
    }

    public String getDataHolderName(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("org.jbpm.formModeler.dataModeler.messages", locale);
        return bundle.getString("dataHolder_dataModeler");
    }
}

