/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.jbpm.formModeler.service.LocaleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Functions {
    private Logger log = LoggerFactory.getLogger(Functions.class);
    private static String[] MONTHS = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    public static final StringUtils String = new StringUtils();
    public static final WordUtils Word = new WordUtils();

    public Map getYearsBetween(int min, int max) throws Exception {
        if (max < min) {
            throw new Exception("Error getting years bewtween " + min + " - " + max + ".");
        }
        TreeMap<String, String> years = new TreeMap<String, String>();
        int year = new GregorianCalendar().get(1);
        for (int i = year + min; i <= year + max; ++i) {
            String value = java.lang.String.valueOf(i);
            years.put(value, value);
        }
        return years;
    }

    public Map getMonths() {
        TreeMap<String, String> months = new TreeMap<String, String>();
        ResourceBundle bundle = ResourceBundle.getBundle("org.jbpm.formModeler.core.processing.formProcessing.messages", LocaleManager.currentLocale());
        for (int i = 0; i < MONTHS.length; ++i) {
            String key = java.lang.String.valueOf(i);
            if (key.length() == 1) {
                key = "0" + key;
            }
            months.put(key, bundle.getString("months." + MONTHS[i]));
        }
        return months;
    }

    public Map getValidDays() {
        return this.getValidDays(null);
    }

    public Map getValidDays(String value) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(5, 1);
        if (value == null || value.equals("") || value.startsWith("/")) {
            gc.set(2, 0);
        } else if (value.endsWith("/")) {
            int month = Integer.decode(value.substring(0, value.indexOf("/")));
            gc.set(2, month);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/yyyy");
            try {
                gc.setTime(sdf.parse(value));
                gc.set(2, gc.get(2) + 1);
            }
            catch (Exception e) {
                this.log.warn("Error parsing date " + value + " : ", (Throwable)e);
            }
        }
        TreeMap<String, String> days = new TreeMap<String, String>();
        int month = gc.get(2);
        while (gc.get(2) == month) {
            int intValue = gc.get(5);
            String key = java.lang.String.valueOf(intValue);
            if (key.length() == 1) {
                key = "0" + key;
            }
            days.put(key, key);
            gc.set(5, intValue + 1);
        }
        return days;
    }

    public Map getValidDays(String sMonth, String sYear) {
        int month = Integer.decode(sMonth);
        int year = Integer.decode(sYear);
        GregorianCalendar gc = new GregorianCalendar(year, month, 1);
        HashMap<Integer, String> days = new HashMap<Integer, String>();
        while (gc.get(2) == month) {
            Integer value = new Integer(gc.get(5));
            days.put(value, value.toString());
            gc.set(5, value + 1);
        }
        return days;
    }

    public Date getDateFromFields(String sDay, String sMonth, String sYear) {
        int day = Integer.decode(sDay);
        int month = Integer.decode(sMonth);
        int year = Integer.decode(sYear);
        GregorianCalendar gc = new GregorianCalendar(year, month, day);
        return gc.getTime();
    }

    public String str() {
        return "";
    }

    public String str(String s) {
        return s;
    }
}

