/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import java.util.StringTokenizer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.rendering.SubformFinderService;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class NamespaceManager {
    @Inject
    private SubformFinderService subformFinderService;
    private Logger log = LoggerFactory.getLogger(NamespaceManager.class);

    public static NamespaceManager lookup() {
        return (NamespaceManager)CDIBeanLocator.getBeanByType(NamespaceManager.class);
    }

    public String generateFieldNamesPace(String namespace, Field field) {
        return this.generateFieldNamesPace(namespace, field.getForm(), field.getFieldName());
    }

    public String generateFieldNamesPace(String namespace, Form form, String fieldName) {
        return namespace + "-" + form.getId() + "-" + fieldName;
    }

    public String squashInputName(String inputName) {
        inputName = inputName.substring(inputName.indexOf("-"));
        StringTokenizer tokenizer = new StringTokenizer(inputName, "-");
        String result = "";
        if (tokenizer.countTokens() % 2 != 0) {
            this.log.warn("Unable to squash field name '{}', wrong number of name parts: {}", (Object)inputName, (Object)tokenizer.countTokens());
            System.out.println("Error! " + tokenizer.countTokens());
            return null;
        }
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (i % 2 != 0) {
                if (!result.isEmpty()) {
                    result = result + "-";
                }
                result = result + token;
            }
            ++i;
        }
        return result;
    }

    public String generateSquashedInputName(String namespace, Field field) {
        if (StringUtils.isEmpty((String)(namespace = this.squashNamespace(namespace)))) {
            return field.getFieldName();
        }
        return namespace + "-" + field.getFieldName();
    }

    protected String squashNamespace(String namespace) {
        if (namespace.indexOf("-") == -1) {
            return "";
        }
        namespace = namespace.substring(namespace.indexOf("-"));
        StringTokenizer tokenizer = new StringTokenizer(namespace, "-");
        String result = "";
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (i % 2 != 0) {
                if (!result.isEmpty()) {
                    result = result + "-";
                }
                result = result + token;
            }
            ++i;
        }
        return result;
    }

    public String getParentNamespace(String namespace) {
        int lastIndex;
        int previousLastIndex;
        if (namespace != null && (previousLastIndex = namespace.lastIndexOf("-", (lastIndex = namespace.lastIndexOf("-")) - 1)) != -1) {
            String parentNamespace = namespace.substring(0, previousLastIndex);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Parent namespace for '" + namespace + "' is '" + parentNamespace + "'");
            }
            return parentNamespace;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Parent namespace for '" + namespace + "' is empty string");
        }
        return "";
    }

    public FormNamespaceData getNamespace(String fieldName) {
        int lastIndex;
        int previousLastIndex;
        if (fieldName != null && (previousLastIndex = fieldName.lastIndexOf("-", (lastIndex = fieldName.lastIndexOf("-")) - 1)) != -1) {
            String formIdString = fieldName.substring(previousLastIndex + 1, lastIndex);
            String namespace = fieldName.substring(0, previousLastIndex);
            String fieldNameInParent = fieldName.substring(lastIndex + 1, fieldName.length());
            if (!"_".equals(formIdString)) {
                Long formId = Long.decode(formIdString);
                try {
                    Form form = this.subformFinderService.getFormById(formId.longValue(), namespace);
                    return new FormNamespaceData(form, namespace, fieldNameInParent);
                }
                catch (Exception e) {
                    this.log.error("Error: ", (Throwable)e);
                }
            }
        }
        return null;
    }
}

