/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.components.renderer;

import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.client.FormRenderContext;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.client.FormRenderContextTO;
import org.jbpm.formModeler.api.events.FormSubmitFailEvent;
import org.jbpm.formModeler.api.events.FormSubmittedEvent;
import org.jbpm.formModeler.api.events.ResizeFormcontainerEvent;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.components.renderer.ContextRemovedEvent;
import org.jbpm.formModeler.components.renderer.ContextRenderedEvent;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.service.annotation.config.Config;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BaseUIComponent;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.DoNothingResponse;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named(value="frc")
public class FormRenderingComponent
extends BaseUIComponent {
    private Logger log = LoggerFactory.getLogger(FormRenderingComponent.class);
    @Inject
    @Config(value="/formModeler/components/renderer/component.jsp")
    private String baseComponentJSP;
    @Inject
    @Config(value="/formModeler/components/renderer/show.jsp")
    private String componentIncludeJSP;
    @Inject
    private FormRenderContextManager formRenderContextManager;
    @Inject
    private FormProcessor formProcessor;
    @Inject
    private Event<ContextRenderedEvent> contextRenderedEventEvent;
    private FormRenderContext ctx;

    public void doStart(CommandRequest commandRequest) {
        String ctxUID = commandRequest.getRequestObject().getParameter("ctxUID");
        if (StringUtils.isEmpty((String)ctxUID)) {
            return;
        }
        this.ctx = this.formRenderContextManager.getFormRenderContext(ctxUID);
    }

    public void beforeRenderBean() {
        if (this.ctx != null) {
            this.ctx.setInUse(true);
        }
    }

    public void afterRenderBean() {
        if (this.ctx != null) {
            this.ctx.setInUse(false);
            this.contextRenderedEventEvent.fire((Object)new ContextRenderedEvent(this.ctx.getUID()));
        }
    }

    public void removeContextEvent(@Observes ContextRemovedEvent event) {
        if (this.ctx != null && this.ctx.getUID().equals(event.getCtxUID())) {
            this.ctx = null;
        }
    }

    public void actionSubmitForm(CommandRequest request) {
        String ctxUID = request.getRequestObject().getParameter("ctxUID");
        if (this.ctx == null || this.ctx.getUID().equals(ctxUID)) {
            this.ctx = this.formRenderContextManager.getFormRenderContext(ctxUID);
        }
        if (this.ctx == null) {
            return;
        }
        try {
            Form form = this.ctx.getForm();
            this.formProcessor.setValues(form, ctxUID, request.getRequestObject().getParameterMap(), request.getFilesByParamName());
            FormStatusData fsd = this.formProcessor.read(ctxUID);
            this.ctx.setErrors(fsd.getWrongFields().size());
            String persist = request.getRequestObject().getParameter("persistForm");
            if (fsd.isValid()) {
                this.ctx.setSubmit(true);
                if (Boolean.parseBoolean(persist)) {
                    this.formRenderContextManager.persistContext(this.ctx);
                }
            }
            this.formRenderContextManager.fireContextSubmit(new FormSubmittedEvent(new FormRenderContextTO(this.ctx)));
        }
        catch (Exception e) {
            this.log.error("Error submitting form: ", (Throwable)e);
            this.formRenderContextManager.fireContextSubmitError(new FormSubmitFailEvent(new FormRenderContextTO(this.ctx), e.getMessage()));
        }
    }

    public CommandResponse actionDoResize(CommandRequest request) {
        String ctxUID = request.getRequestObject().getParameter("ctxUID");
        if (this.ctx == null || this.ctx.getUID().equals(ctxUID)) {
            this.ctx = this.formRenderContextManager.getFormRenderContext(ctxUID);
        }
        if (this.ctx != null) {
            String width = request.getRequestObject().getParameter("width");
            String height = request.getRequestObject().getParameter("height");
            if (!StringUtils.isEmpty((String)width) && !StringUtils.isEmpty((String)height)) {
                ResizeFormcontainerEvent event = new ResizeFormcontainerEvent();
                event.setContext(new FormRenderContextTO(this.ctx));
                event.setWidth(Integer.decode(width).intValue());
                event.setHeight(Integer.decode(height).intValue());
                this.formRenderContextManager.fireContextFormResize(event);
            }
        }
        return new DoNothingResponse();
    }

    public String getCtxUID() {
        return this.ctx.getUID();
    }

    public Form getForm() {
        return this.ctx == null ? null : this.ctx.getForm();
    }

    public boolean isReadonly() {
        return this.ctx.isReadonly();
    }

    public void setBaseComponentJSP(String baseComponentJSP) {
        this.baseComponentJSP = baseComponentJSP;
    }

    public void setComponentIncludeJSP(String componentIncludeJSP) {
        this.componentIncludeJSP = componentIncludeJSP;
    }

    public String getBaseComponentJSP() {
        return this.baseComponentJSP;
    }

    public String getBeanJSP() {
        return this.componentIncludeJSP;
    }

    public FormProcessor getFormProcessor() {
        return this.formProcessor;
    }

    public void setFormProcessor(FormProcessor formProcessor) {
        this.formProcessor = formProcessor;
    }

    public static FormRenderingComponent lookup() {
        return (FormRenderingComponent)((Object)CDIBeanLocator.getBeanByType(FormRenderingComponent.class));
    }

    public boolean isSubmited() {
        return this.ctx.isSubmit();
    }
}

