/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.fieldHandlers.CreateDynamicObjectFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.core.processing.fieldHandlers.subform.checkers.FormCheckResult;
import org.jbpm.formModeler.core.processing.fieldHandlers.subform.checkers.SubformChecker;
import org.jbpm.formModeler.core.processing.fieldHandlers.subform.utils.SubFormHelper;
import org.jbpm.formModeler.core.processing.formRendering.FieldI18nResourceObtainer;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="CreateDynamicObjectFieldFormatter")
public class CreateDynamicObjectFieldFormatter
extends DefaultFieldHandlerFormatter {
    private static transient Logger log = LoggerFactory.getLogger(CreateDynamicObjectFieldFormatter.class);
    public static final String PARAM_DISPLAYPAGE = "displayPage";
    public static final String PROPERTY_DISALLOW_CREATE_NEW = "disallowCreateNew";
    public static final String PROPERTY_MODIFICABLE = "modificable";
    public static final String PROPERTY_DELETEABLE = "deleteable";
    public static final String PROPERTY_VISUALIZABLE = "visualizable";
    public static final String PROPERTY_PREVIEW_ITEMS = "previewItems";
    public static final String PROPERTY_SEPARATOR = "htmlContent";
    @Inject
    protected FieldI18nResourceObtainer fieldI18nResourceObtainer;
    @Inject
    protected SubFormHelper helper;
    protected Boolean isReadonly;
    protected String renderMode;
    protected String fieldUID;
    protected String fieldNS;

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FormatterException {
        Boolean displayPage = Boolean.valueOf((String)this.getParameter(PARAM_DISPLAYPAGE));
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(httpServletRequest);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        String currentNamespace = paramsReader.getCurrentNamespace();
        Object value = paramsReader.getCurrentFieldValue();
        this.fieldNS = paramsReader.getCurrentFieldName();
        this.renderMode = paramsReader.getCurrentRenderMode();
        this.isReadonly = paramsReader.isFieldReadonly();
        this.fieldUID = this.namespaceManager.squashInputName(this.fieldNS);
        CreateDynamicObjectFieldHandler fHandler = (CreateDynamicObjectFieldHandler)this.getFieldHandlersManager().getHandler(field.getFieldType());
        Form createForm = fHandler.getCreateForm(field, currentNamespace);
        Set<SubformChecker> checkers = fHandler.getSubformCheckers();
        for (SubformChecker checker : checkers) {
            FormCheckResult result = checker.checkForm(createForm);
            if (result.isValid()) continue;
            this.setAttribute("error", result.getMessageKey());
            this.renderFragment("renderError");
            return;
        }
        if (!CreateDynamicObjectFieldHandler.checkSubformDepthAllowed(form, currentNamespace)) {
            return;
        }
        if (!displayPage.booleanValue() && field != null && Boolean.TRUE.equals(field.getReadonly())) {
            this.includePage(fHandler.getPageToIncludeForDisplaying());
            return;
        }
        FormNamespaceData rootNamespaceData = this.namespaceManager.getRootNamespace(this.fieldNS);
        Integer previewIndex = this.helper.getPreviewFieldPosition(this.fieldNS);
        Integer editIndex = this.helper.getEditFieldPosition(this.fieldNS);
        this.setDefaultAttributes(field, form, currentNamespace);
        String height = field.getHeight() != null && !"".equals(field.getHeight()) ? field.getHeight() : "100";
        this.setAttribute("uid", this.fieldUID);
        this.setAttribute("tableEnterMode", Boolean.TRUE.equals(field.getEnableTableEnterData()));
        int count = 0;
        if (value != null) {
            count = ((Object[])value).length;
        }
        this.setAttribute("count", count);
        this.setAttribute("name", this.fieldNS);
        this.setAttribute("heightDesired", height);
        this.renderFragment("outputStart");
        if (previewIndex != null) {
            String rowNamespace = this.fieldNS + "." + previewIndex;
            this.getFormProcessor().read(form, rowNamespace, ((Map[])value)[previewIndex]);
            this.previewItemInPosition(form, currentNamespace, previewIndex, field, value);
        } else if (editIndex != null) {
            String rowNamespace = this.fieldNS + "." + editIndex;
            this.getFormProcessor().read(form, rowNamespace, ((Map[])value)[editIndex]);
            this.editItemInPosition(form, currentNamespace, editIndex, field, value, this.fieldNS);
        } else {
            this.renderFragment("beforeItemsTable");
            this.renderExistingItemsTable(form, currentNamespace, field, value);
            this.renderFragment("afterItemsTable");
            this.renderFragment("beforeNewItemForm");
            this.renderNewItemForm(form, field, currentNamespace, this.fieldNS, this.renderMode);
            this.renderFragment("afterNewItemForm");
        }
        this.renderFragment("outputEnd");
    }

    protected void previewItemInPosition(Form parentForm, String currentNamespace, int position, Field field, Object value) {
        if (value != null && value.getClass().isArray()) {
            CreateDynamicObjectFieldHandler fieldHandler = (CreateDynamicObjectFieldHandler)this.getFieldHandlersManager().getHandler(field.getFieldType());
            Form formToPreview = fieldHandler.getPreviewDataForm(field, currentNamespace);
            Map valueToPreview = (Map)Array.get(value, position);
            if (formToPreview != null) {
                this.setAttribute("valueToPreview", valueToPreview);
                this.setAttribute("form", formToPreview);
                this.setAttribute("uid", this.fieldUID);
                this.setAttribute("index", position);
                this.setAttribute("parentFormId", parentForm.getId());
                this.setAttribute("namespace", this.fieldNS);
                this.setAttribute("parentNamespace", currentNamespace);
                this.setAttribute("field", field.getFieldName());
                if (this.isReadonly.booleanValue()) {
                    this.setAttribute("readonly", this.isReadonly);
                }
                this.renderFragment("previewItem");
            } else {
                this.renderFragment("noShowDataForm");
            }
        }
    }

    protected void editItemInPosition(Form parentForm, String currentNamespace, int position, Field field, Object value, String fieldName) {
        if (value != null && value.getClass().isArray()) {
            CreateDynamicObjectFieldHandler fieldHandler = (CreateDynamicObjectFieldHandler)this.getFieldHandlersManager().getHandler(field.getFieldType());
            Form formToEdit = fieldHandler.getEditForm(field, currentNamespace);
            Map valueToEdit = (Map)Array.get(value, position);
            if (formToEdit != null) {
                this.setAttribute("valueToEdit", valueToEdit);
                this.setAttribute("name", fieldName);
                this.setAttribute("form", formToEdit);
                this.setAttribute("uid", this.fieldUID);
                this.setAttribute("index", position);
                this.setAttribute("parentFormId", parentForm.getId());
                this.setAttribute("namespace", this.fieldNS);
                this.setAttribute("parentNamespace", currentNamespace);
                this.setAttribute("field", field.getFieldName());
                if (this.isReadonly.booleanValue()) {
                    this.setAttribute("readonly", this.isReadonly);
                }
                String rowNamespace = this.fieldNS + "." + position;
                this.getFormProcessor().clear(formToEdit, rowNamespace);
                this.getFormProcessor().read(formToEdit, rowNamespace, valueToEdit);
                this.renderFragment("editItem");
            }
        }
    }

    protected void renderNewItemForm(Form form, Field field, String currentNamespace, String fieldName, String renderMode) {
        CreateDynamicObjectFieldHandler fieldHandler = (CreateDynamicObjectFieldHandler)this.getFieldHandlersManager().getHandler(field.getFieldType());
        Form enterDataForm = fieldHandler.getCreateForm(field, currentNamespace);
        boolean disallowCreateNew = Boolean.TRUE.equals(field.getHideCreateItem());
        if (enterDataForm != null && !disallowCreateNew) {
            this.setAttribute("form", enterDataForm);
            this.setAttribute("namespace", this.fieldNS + "." + "create");
            this.setAttribute("uid", this.fieldUID);
            this.setAttribute("name", fieldName);
            this.setAttribute("entityName", "");
            boolean expanded = false;
            if (Boolean.TRUE.equals(field.getHideContent())) {
                expanded = true;
                this.setAttribute("noCancelButton", true);
            } else {
                expanded = this.fieldNS.equals(this.helper.getExpandedField(this.fieldNS));
            }
            this.setAttribute("expanded", expanded);
            String newItemButtonText = field.getNewItemText().getValue(this.getLocaleManager().getCurrentLang());
            if (StringUtils.isEmpty((String)newItemButtonText)) {
                newItemButtonText = "Create";
            }
            this.setAttribute("newItemButtonText", newItemButtonText);
            String addItemButtonText = field.getAddItemText().getValue(this.getLocaleManager().getCurrentLang());
            if (StringUtils.isEmpty((String)addItemButtonText)) {
                addItemButtonText = "Add new item";
            }
            this.setAttribute("addItemButtonText", addItemButtonText);
            String cancelButtonText = field.getCancelItemText().getValue(this.getLocaleManager().getCurrentLang());
            if (StringUtils.isEmpty((String)cancelButtonText)) {
                cancelButtonText = "Cancel";
            }
            this.setAttribute("cancelButtonText", cancelButtonText);
            if (this.isReadonly.booleanValue()) {
                this.setAttribute("readonly", this.isReadonly);
            }
            this.setAttribute("renderMode", renderMode);
            this.renderFragment("outputEnterDataForm");
        }
    }

    protected void renderExistingItemsTable(Form parentForm, String currentNamespace, Field field, Object value) {
        List values;
        Boolean displayPage = Boolean.valueOf((String)this.getParameter(PARAM_DISPLAYPAGE));
        CreateDynamicObjectFieldHandler fieldHandler = (CreateDynamicObjectFieldHandler)this.getFieldHandlersManager().getHandler(field.getFieldType());
        Form form = fieldHandler.calculateFieldForm(field, field.getTableSubform(), currentNamespace);
        if (value != null && value.getClass().isArray()) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(Array.get(value, i));
            }
            value = l;
        }
        if ((values = (List)value) != null && !values.isEmpty()) {
            this.setAttribute("className", "skn-table_border");
            this.setAttribute("uid", this.fieldUID);
            this.renderFragment("tableStart");
            boolean modificable = this.isReadonly == false && Boolean.TRUE.equals(field.getUpdateItems());
            boolean deleteable = this.isReadonly == false && Boolean.TRUE.equals(field.getDeleteItems());
            boolean visualizable = Boolean.TRUE.equals(field.getVisualizeItem());
            int colspan = 0;
            if (modificable) {
                ++colspan;
            }
            if (deleteable) {
                ++colspan;
            }
            if (visualizable) {
                ++colspan;
            }
            this.setAttribute("colspan", colspan);
            this.renderFragment("headerStart");
            Set formFields = form.getFormFields();
            ArrayList sortedFields = new ArrayList(formFields);
            Collections.sort(sortedFields, new Field.Comparator());
            for (Field formField : sortedFields) {
                String colLabel = StringEscapeUtils.escapeHtml((String)this.fieldI18nResourceObtainer.getFieldLabel(formField));
                this.setAttribute("colLabel", StringUtils.defaultString((String)colLabel, (String)formField.getFieldName()));
                String colName = formField.getFieldName();
                this.setAttribute("colName", colName);
                this.renderFragment("outputColumnName");
            }
            this.renderFragment("headerEnd");
            try {
                for (int i = 0; i < values.size(); ++i) {
                    this.setAttribute("index", i);
                    this.setAttribute(PROPERTY_DELETEABLE, deleteable);
                    this.setAttribute(PROPERTY_MODIFICABLE, modificable);
                    this.setAttribute(PROPERTY_VISUALIZABLE, visualizable);
                    this.setAttribute("uid", this.fieldUID);
                    this.setAttribute("parentFormId", parentForm.getId());
                    this.setAttribute("parentNamespace", currentNamespace);
                    this.setAttribute("field", field.getFieldName());
                    this.setAttribute("namespace", this.fieldNS);
                    this.renderFragment("outputSubformActions");
                    Object o = values.get(i);
                    this.setAttribute("formValues", o);
                    this.setAttribute("form", form);
                    String rowNamespace = this.fieldNS + "." + i;
                    this.getFormProcessor().read(form, rowNamespace, (Map)o);
                    this.setAttribute("namespace", rowNamespace);
                    if (Boolean.TRUE.equals(field.getEnableTableEnterData())) {
                        this.setAttribute("renderMode", this.renderMode);
                    } else {
                        this.setAttribute("renderMode", "display");
                    }
                    if (this.isReadonly.booleanValue()) {
                        this.setAttribute("readonly", this.isReadonly);
                    }
                    this.setAttribute("labelMode", "hidden");
                    this.renderFragment("tableRow");
                }
            }
            catch (Exception e) {
                log.error("Error: ", (Throwable)e);
            }
            this.renderFragment("tableEnd");
        }
    }
}

