/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.text.DecimalFormat;
import java.util.Map;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="RangeInputTextFieldHandlerFormatter")
public class RangeInputTextFieldHandlerFormatter
extends DefaultFieldHandlerFormatter {
    private Logger log = LoggerFactory.getLogger(RangeInputTextFieldHandlerFormatter.class);

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(httpServletRequest);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        int position = paramsReader.getCurrentPosition();
        String namespace = paramsReader.getCurrentNamespace();
        boolean wrong = paramsReader.isWrongField();
        String inputValue = paramsReader.getInputValue();
        Boolean isReadonly = paramsReader.isFieldReadonly();
        boolean forceShow = Boolean.TRUE.equals(field.getIsHTML());
        Map rangeFormulas = (Map)this.getFormProcessor().getAttribute(form, namespace, "-jbpm-rangeFormulas");
        Map fieldRange = rangeFormulas != null ? (Map)rangeFormulas.get(field.getFieldName()) : null;
        this.setDefaultAttributes(field, form, namespace);
        String fieldId = this.namespaceManager.squashInputName(fieldName);
        if (fieldRange != null && !forceShow) {
            String keyValueStr = StringEscapeUtils.escapeHtml((String)StringUtils.defaultString((String)(value == null ? "" : String.valueOf(value))));
            String showValue = "";
            if (!StringUtils.isEmpty((String)keyValueStr)) {
                showValue = (String)fieldRange.get(keyValueStr);
            }
            this.setAttribute("size", 1);
            this.setAttribute("name", fieldName);
            this.setAttribute("lang", this.getLang());
            this.setAttribute("uid", fieldId);
            this.setAttribute("value", StringUtils.defaultString((String)showValue));
            if (isReadonly.booleanValue()) {
                this.setAttribute("readonly", isReadonly);
            }
            this.setAttribute("onChangeScript", field.getOnChangeScript());
            this.renderFragment("outputStartRange");
            this.renderFragment("outputRange");
            for (Object key : fieldRange.keySet()) {
                this.setAttribute("key", key);
                String valueKey = (String)fieldRange.get(key);
                this.setAttribute("value", valueKey);
                if (keyValueStr != null && keyValueStr.equals(key.toString())) {
                    this.renderFragment("outputSelectedRange");
                    continue;
                }
                this.renderFragment("outputRange");
            }
            this.renderFragment("outputEndRange");
        } else {
            value = this.applyPattern(field, value);
            this.setAttribute("value", value);
            this.setAttribute("wrong", wrong);
            this.setAttribute("inputValue", inputValue);
            this.setAttribute("position", position);
            this.setAttribute("name", fieldName);
            this.setAttribute("lang", this.getLang());
            this.setAttribute("uid", fieldId);
            if (isReadonly.booleanValue()) {
                this.setAttribute("readonly", isReadonly);
            }
            if (!isReadonly.booleanValue()) {
                this.setAttribute("onChangeScript", field.getOnChangeScript());
            }
            this.renderFragment(forceShow ? "outputForceShowMode" : "output");
        }
    }

    protected Object applyPattern(Field field, Object value) {
        if (value != null) {
            DecimalFormat nf;
            String pattern;
            if (value instanceof Double) {
                pattern = field.getPattern();
                if (pattern == null || "".equals(pattern)) {
                    pattern = field.getFieldType().getPattern();
                }
                if (pattern != null && !"".equals(value)) {
                    nf = (DecimalFormat)DecimalFormat.getInstance(this.getLocale());
                    nf.applyPattern(pattern);
                    value = nf.format((Double)value);
                }
            }
            if (value instanceof Object[]) {
                pattern = field.getPattern();
                if (pattern == null || "".equals(pattern)) {
                    pattern = field.getFieldType().getPattern();
                }
                if (pattern != null) {
                    nf = (DecimalFormat)DecimalFormat.getInstance(this.getLocale());
                    nf.applyPattern(pattern);
                    Object[] values = value;
                    for (int i = 0; i < values.length; ++i) {
                        Object object = values[i];
                        if (object == null || !(object instanceof Double)) continue;
                        Double aDouble = (Double)object;
                        values[i] = nf.format(aDouble);
                    }
                    value = values;
                }
            }
        }
        return value;
    }
}

