/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.formStatus.FormStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormStatusDataImpl
implements FormStatusData {
    private static transient Logger log = LoggerFactory.getLogger((String)FormStatusDataImpl.class.getName());
    private List wrongFields;
    private Map wrongFieldsMessages;
    private boolean valid;
    private boolean empty;
    private Map currentValues;
    private Map currentInputValues;
    private boolean isNew;
    private Map attributes = new HashMap();
    private Map<String, Object> loadedObjects = new HashMap<String, Object>();

    public FormStatusDataImpl(FormStatus status, boolean isNew) {
        this.setCurrentValues(status.getInputValues() != null ? Collections.unmodifiableMap(status.getInputValues()) : null);
        this.setCurrentInputValues(status.getLastParameterMap() != null ? Collections.unmodifiableMap(status.getLastParameterMap()) : null);
        this.setNew(isNew);
        this.setWrongFields(status.getWrongFields() != null ? Collections.unmodifiableList(new ArrayList(status.getWrongFields())) : null);
        this.setWrongFieldsMessages(status.getWrongFieldsMessages() != null ? Collections.unmodifiableMap(new HashMap(status.getWrongFieldsMessages())) : null);
        this.setValid(this.wrongFields == null || this.wrongFields.isEmpty());
        this.loadedObjects.putAll(status.getLoadedObjects());
        Map inputValues = status.getInputValues();
        this.setEmpty(true);
        Form form = null;
        try {
            form = status.getRelatedForm();
            for (Field field : form.getFormFields()) {
                FieldHandler fieldHandler;
                Object value = inputValues.get(field.getFieldName());
                if (value == null || (fieldHandler = FormProcessingServices.lookup().getFieldHandlersManager().getHandler(field.getFieldType())).isEmpty(value)) continue;
                this.setEmpty(false);
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        this.setAttributes(status.getAttributes() != null ? Collections.unmodifiableMap(status.getAttributes()) : null);
    }

    public void setAttributes(Map map) {
        this.attributes = map;
    }

    public void setCurrentInputValues(Map map) {
        this.currentInputValues = map;
    }

    public List getWrongFields() {
        return this.wrongFields != null ? this.wrongFields : Collections.EMPTY_LIST;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Object getCurrentValue(String fieldName) {
        return this.currentValues.get(fieldName);
    }

    public String getCurrentInputValue(String inputName) {
        if (this.currentInputValues == null) {
            return null;
        }
        String[] params = (String[])this.currentInputValues.get(inputName);
        if (params != null && params.length == 1) {
            return params[0];
        }
        return null;
    }

    public Map getCurrentValues() {
        return this.currentValues != null ? Collections.unmodifiableMap(this.currentValues) : Collections.EMPTY_MAP;
    }

    public Map getCurrentInputValues() {
        return this.currentInputValues;
    }

    public void clear() {
        this.wrongFields = null;
        this.valid = false;
        this.currentValues = null;
        this.isNew = true;
    }

    public void setCurrentValues(Map currentValues) {
        this.currentValues = currentValues;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setWrongFields(List wrongFields) {
        this.wrongFields = wrongFields;
    }

    public void setNew(boolean b) {
        this.isNew = b;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FormStatusData: ");
        sb.append(" valid=").append(this.valid);
        if (!this.valid) {
            sb.append(" wrongFields=").append(this.wrongFields);
        }
        sb.append(" currentValues=").append(this.currentValues);
        sb.append(" currentInputValues=").append(this.currentInputValues);
        return sb.toString();
    }

    public boolean hasErrorMessage(String fieldName) {
        return !CollectionUtils.isEmpty((Collection)((Collection)this.wrongFieldsMessages.get(fieldName)));
    }

    public List getErrorMessages(String fieldName) {
        return (List)this.wrongFieldsMessages.get(fieldName);
    }

    public Map getWrongFieldsMessages() {
        return this.wrongFieldsMessages;
    }

    public void setWrongFieldsMessages(Map<String, String> wrongFieldsMessages) {
        this.wrongFieldsMessages = wrongFieldsMessages;
    }

    public Object getLoadedObject(String id) {
        return this.loadedObjects.get(id);
    }
}

