/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.multipleSubform;

import java.lang.reflect.Array;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.core.processing.fieldHandlers.subform.utils.SubFormHelper;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;

public abstract class AbstractMultipleSubformItemFormatter
extends DefaultFieldHandlerFormatter {
    @Inject
    protected SubFormHelper helper;

    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        String currentNamespace = paramsReader.getCurrentNamespace();
        Object value = paramsReader.getCurrentFieldValue();
        String fieldNS = paramsReader.getCurrentFieldName();
        Integer position = this.getItemPosition(fieldNS);
        boolean isReadonly = paramsReader.isFieldReadonly();
        String fieldUID = this.namespaceManager.squashInputName(fieldNS);
        if (position != null && value != null && value.getClass().isArray()) {
            String rowNamespace = fieldNS + "." + position;
            this.getFormProcessor().read(form, rowNamespace, ((Map[])value)[position]);
            Form formToRender = this.getForm(field, currentNamespace);
            Map valueToEdit = (Map)Array.get(value, position);
            if (formToRender != null) {
                this.setAttribute("value", valueToEdit);
                this.setAttribute("name", fieldNS);
                this.setAttribute("form", formToRender);
                this.setAttribute("uid", fieldUID);
                this.setAttribute("index", position);
                this.setAttribute("parentFormId", form.getId());
                this.setAttribute("namespace", fieldNS);
                this.setAttribute("parentNamespace", currentNamespace);
                this.setAttribute("field", field.getFieldName());
                if (isReadonly) {
                    this.setAttribute("readonly", isReadonly);
                }
                this.renderFragment("output");
            } else {
                this.renderFragment("noShowDataForm");
            }
        }
    }

    protected abstract Integer getItemPosition(String var1);

    protected abstract Form getForm(Field var1, String var2);
}

