/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.FieldTypeManager;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterTag;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.ProcessingInstruction;
import org.junit.After;
import org.junit.Before;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class DefaultFieldHandlerFormatterTest<T extends DefaultFieldHandlerFormatter>
extends TestCase {
    protected FieldTypeManager fieldTypeManager;
    protected NamespaceManager namespaceManager;
    protected HttpServletRequest httpServletRequest;
    protected HttpServletResponse httpServletResponse;
    protected T formatter;
    protected FormatterTag tag;
    protected String currentNamespace;
    protected Form form;
    protected Field currentField;
    protected Weld weld;
    protected WeldContainer weldContainer;

    @Before
    public void setup() {
        this.weld = new Weld();
        this.weldContainer = this.weld.initialize();
        this.fieldTypeManager = (FieldTypeManager)this.weldContainer.instance().select(FieldTypeManager.class, new Annotation[0]).get();
        this.namespaceManager = (NamespaceManager)this.weldContainer.instance().select(NamespaceManager.class, new Annotation[0]).get();
        this.initDependencies();
        this.initFormatter();
        this.httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.httpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.form = new Form();
        this.form.setName("test");
        this.form.setId(Long.valueOf(System.currentTimeMillis()));
        this.initNamespace();
        this.initCurrentField();
        Mockito.when((Object)this.httpServletRequest.getAttribute("_ddm_currentField")).thenAnswer((Answer)new Answer<Field>(){

            public Field answer(InvocationOnMock invocation) throws Throwable {
                return DefaultFieldHandlerFormatterTest.this.currentField;
            }
        });
        Mockito.when((Object)this.httpServletRequest.getAttribute("_ddm_currentNamespace")).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return DefaultFieldHandlerFormatterTest.this.currentNamespace;
            }
        });
        Mockito.when((Object)this.httpServletRequest.getAttribute("_ddm_currentName")).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return DefaultFieldHandlerFormatterTest.this.currentNamespace + "-" + DefaultFieldHandlerFormatterTest.this.currentField.getFieldName();
            }
        });
        this.mockRequestAttributes();
    }

    @After
    public void cleanup() {
        if (this.weld != null) {
            this.weld.shutdown();
        }
    }

    protected void initNamespace() {
        this.currentNamespace = "formRenderCtx_" + this.form.getId() + "_" + System.currentTimeMillis() + "-" + this.form.getId();
    }

    protected void initFormatter() {
        this.formatter = this.getFormatterInstance();
        ((DefaultFieldHandlerFormatter)this.formatter).namespaceManager = this.namespaceManager;
        this.tag = (FormatterTag)Mockito.mock(FormatterTag.class);
        this.formatter.setTag(this.tag);
    }

    protected void initCurrentField() {
        this.currentField = this.getMockedField();
        this.currentField.setId(Long.valueOf(System.currentTimeMillis()));
        this.currentField.setForm(this.form);
    }

    protected abstract void initDependencies();

    protected abstract T getFormatterInstance();

    protected abstract void mockRequestAttributes();

    protected abstract Field getMockedField();

    public class FormatterFragmentMatcher
    extends ArgumentMatcher<ProcessingInstruction> {
        protected List<String> fragments;
        protected Map<String, Object> params = new HashMap<String, Object>();

        public FormatterFragmentMatcher(List<String> fragments) {
            this.fragments = fragments;
        }

        public void addParam(String name, Object value) {
            this.params.put(name, value);
        }

        public boolean matches(Object argument) {
            if (argument instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)argument;
                switch (pi.getType()) {
                    case 0: {
                        return this.fragments.contains(pi.getName());
                    }
                    case 1: {
                        Object paramValue = this.params.get(pi.getName());
                        if (paramValue == null) break;
                        return paramValue.equals(pi.getValue());
                    }
                }
            }
            return true;
        }
    }
}

