/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.date;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.hamcrest.Matcher;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.processing.fieldHandlers.date.AbstractDateFieldHandlerFormatterTest;
import org.jbpm.formModeler.core.processing.fieldHandlers.date.DateFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.date.DateFieldHandlerFormatter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterTag;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.ProcessingInstruction;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DateFieldHandlerFormatterWithDefaultValueTest
extends AbstractDateFieldHandlerFormatterTest<DateFieldHandler> {
    public static final Date DEFAULT_DATE = new Date();

    @Override
    public void setup() {
        super.setup();
        SimpleDateFormat sdf = new SimpleDateFormat(this.fieldHandler.getDefaultPattern(), this.localeManager.getCurrentLocale());
        this.tagMatcher.addParam("value", sdf.format(DEFAULT_DATE));
    }

    @Override
    protected DateFieldHandler getHandler() {
        return new DateFieldHandler();
    }

    @Test
    public void testRendering() throws Exception {
        ((DateFieldHandlerFormatter)this.formatter).service(this.httpServletRequest, this.httpServletResponse);
        ((FormatterTag)Mockito.verify((Object)this.tag, (VerificationMode)Mockito.atLeastOnce())).addProcessingInstruction((ProcessingInstruction)Matchers.argThat((Matcher)this.tagMatcher));
    }

    @Override
    protected void mockRequestAttributes() {
        Mockito.when((Object)this.httpServletRequest.getAttribute("_ddm_currentValue")).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return DEFAULT_DATE;
            }
        });
    }

    @Override
    protected Field getMockedField() {
        Field currentField = new Field();
        currentField.setFieldType(this.fieldTypeManager.getTypeByCode("InputDate"));
        currentField.setFieldName("date");
        currentField.setDefaultValueFormula("= new java.util.Date()");
        return currentField;
    }
}

