/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.fieldHandlers.mocks.SubformFinderServiceMock;
import org.jbpm.formModeler.core.processing.impl.AbstractFormProcessorImplTest;
import org.jbpm.formModeler.core.processing.impl.model.Hobby;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MultipleSubformAsBasicDataFormProcessorImplTest
extends AbstractFormProcessorImplTest {
    public static final String ORIGINAL_HOBBY1_NAME = "Astronomy";
    public static final Integer ORIGINAL_HOBBY1_LEVEL = 3;
    public static final String ORIGINAL_HOBBY2_NAME = "Running";
    public static final Integer ORIGINAL_HOBBY2_LEVEL = 6;
    public static final String EXPECTED_HOBBY1_NAME = "Playing Guitar";
    public static final Integer EXPECTED_HOBBY1_LEVEL = 10;
    public static final String EXPECTED_HOBBY2_NAME = "Biking";
    public static final Integer EXPECTED_HOBBY2_LEVEL = 7;
    public static final String EXPECTED_HOBBY3_NAME = "Coding Java";
    public static final Integer EXPECTED_HOBBY3_LEVEL = 3;
    private List<Hobby> expectedHobbies = new ArrayList<Hobby>();
    protected SubformFinderServiceMock subformFinderService;
    protected Form hobbyForm;

    @Override
    public void init() {
        super.init();
        this.expectedHobbies.add(new Hobby(EXPECTED_HOBBY1_NAME, EXPECTED_HOBBY1_LEVEL));
        this.expectedHobbies.add(new Hobby(EXPECTED_HOBBY2_NAME, EXPECTED_HOBBY2_LEVEL));
        this.expectedHobbies.add(new Hobby(EXPECTED_HOBBY3_NAME, EXPECTED_HOBBY3_LEVEL));
        this.form = this.formGenerator.generateMultipleSubformForm();
        this.hobbyForm = this.formGenerator.generateHobbyForm();
        this.subformFinderService = (SubformFinderServiceMock)this.weldContainer.instance().select(SubformFinderServiceMock.class, new Annotation[0]).get();
        this.subformFinderService.addFormContext(this.form);
        this.subformFinderService.addForm(this.hobbyForm);
    }

    @Test
    public void testPersistDataWithoutInputs() throws Exception {
        this.initContext();
        FormStatusData data = this.processor.read("ctxUID");
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)1L, (long)data.getCurrentValues().size());
        Object actualHobbies = data.getCurrentValue("hobbies");
        Assert.assertNotNull((Object)actualHobbies);
        Assert.assertTrue((boolean)(actualHobbies instanceof Map[]));
        Assert.assertEquals((long)0L, (long)((Map[])actualHobbies).length);
        Mockito.when((Object)this.processor.getFilteredMapRepresentationToPersist(this.context.getForm(), this.context.getUID())).thenReturn((Object)this.generateExpectedValuesMap());
        this.processor.persist("ctxUID");
        Assert.assertNotNull(this.context.getOutputData().get("hobbies"));
        Assert.assertTrue((boolean)(this.context.getOutputData().get("hobbies") instanceof List));
        List resultHobbies = (List)this.context.getOutputData().get("hobbies");
        Assert.assertFalse((boolean)resultHobbies.isEmpty());
        Assert.assertEquals((long)this.expectedHobbies.size(), (long)resultHobbies.size());
        Assert.assertEquals(this.expectedHobbies, (Object)resultHobbies);
    }

    @Test
    public void testPersistDataWithInputs() throws Exception {
        ArrayList<Hobby> originalHobbies = new ArrayList<Hobby>();
        originalHobbies.add(new Hobby(ORIGINAL_HOBBY1_NAME, ORIGINAL_HOBBY1_LEVEL));
        originalHobbies.add(new Hobby(ORIGINAL_HOBBY2_NAME, ORIGINAL_HOBBY2_LEVEL));
        this.inputs.put("hobbies", originalHobbies);
        this.initContext();
        FormStatusData data = this.processor.read("ctxUID");
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)1L, (long)data.getCurrentValues().size());
        Object actualHobbies = data.getCurrentValue("hobbies");
        Assert.assertNotNull((Object)actualHobbies);
        Assert.assertTrue((boolean)(actualHobbies instanceof Map[]));
        Assert.assertEquals((long)2L, (long)((Map[])actualHobbies).length);
        Map[] actualHobbiesMap = (Map[])actualHobbies;
        Map hobby1Map = actualHobbiesMap[0];
        Assert.assertEquals((Object)ORIGINAL_HOBBY1_NAME, hobby1Map.get("name"));
        Assert.assertEquals((Object)ORIGINAL_HOBBY1_LEVEL, hobby1Map.get("level"));
        Map hobby2Map = actualHobbiesMap[1];
        Assert.assertEquals((Object)ORIGINAL_HOBBY2_NAME, hobby2Map.get("name"));
        Assert.assertEquals((Object)ORIGINAL_HOBBY2_LEVEL, hobby2Map.get("level"));
        Mockito.when((Object)this.processor.getFilteredMapRepresentationToPersist(this.context.getForm(), this.context.getUID())).thenReturn((Object)this.generateExpectedValuesMap());
        this.processor.persist("ctxUID");
        Assert.assertNotNull(this.context.getOutputData().get("hobbies"));
        Assert.assertTrue((boolean)(this.context.getOutputData().get("hobbies") instanceof List));
        List resultHobbies = (List)this.context.getOutputData().get("hobbies");
        Assert.assertFalse((boolean)resultHobbies.isEmpty());
        Assert.assertEquals((long)this.expectedHobbies.size(), (long)resultHobbies.size());
        Assert.assertEquals(this.expectedHobbies, (Object)resultHobbies);
    }

    private Map generateExpectedValuesMap() {
        HashMap<String, Map[]> modifiedValues = new HashMap<String, Map[]>();
        HashMap<String, Object> hobby1 = new HashMap<String, Object>();
        hobby1.put("name", EXPECTED_HOBBY1_NAME);
        hobby1.put("level", EXPECTED_HOBBY1_LEVEL);
        HashMap<String, Object> hobby2 = new HashMap<String, Object>();
        hobby2.put("name", EXPECTED_HOBBY2_NAME);
        hobby2.put("level", EXPECTED_HOBBY2_LEVEL);
        HashMap<String, Object> hobby3 = new HashMap<String, Object>();
        hobby3.put("name", EXPECTED_HOBBY3_NAME);
        hobby3.put("level", EXPECTED_HOBBY3_LEVEL);
        modifiedValues.put("hobbies", new Map[]{hobby1, hobby2, hobby3});
        return modifiedValues;
    }
}

