/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.wrappers.I18nEntry;
import org.jbpm.formModeler.api.model.wrappers.I18nSet;
import org.jbpm.formModeler.core.processing.DefaultFieldHandler;
import org.jbpm.formModeler.service.LocaleManager;

public class I18nTextAreaFieldHandler
extends DefaultFieldHandler {
    public boolean isEmpty(Object value) {
        if (value == null || ((I18nSet)value).isEmpty()) {
            return true;
        }
        if ("".equals(((I18nSet)value).getValue(LocaleManager.lookup().getDefaultLang()))) {
            return true;
        }
        for (I18nEntry entry : (I18nSet)value) {
            if (entry.getValue() == null || "".equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String[] getCompatibleClassNames() {
        return new String[]{I18nSet.class.getName()};
    }

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        I18nSet set = new I18nSet();
        for (String key : parametersMap.keySet()) {
            if (key.length() <= inputName.length() || !key.startsWith(inputName)) continue;
            String lang = key.substring(inputName.length() + 1);
            String value = ((String[])parametersMap.get(key))[0];
            set.setValue(lang, value);
        }
        return set.isEmpty() ? null : set;
    }

    public Map getParamValue(Field field, String inputName, Object objectValue) {
        if (objectValue == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        I18nSet value = (I18nSet)objectValue;
        for (I18nEntry entry : value) {
            m.put(inputName + "_" + entry.getLang(), new String[]{(String)entry.getValue()});
        }
        m.put(inputName, new String[0]);
        return m;
    }
}

