/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeResponse;
import org.jbpm.formModeler.core.processing.formProcessing.FormulasCalculatorChangeProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BeanHandler;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.DoNothingResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FormChangeHandler
extends BeanHandler {
    private Logger log = LoggerFactory.getLogger(FormChangeHandler.class);
    @Inject
    private FormProcessor formProcessor;
    @Inject
    private FormulasCalculatorChangeProcessor changeProcessor;

    public boolean isEnabledForActionHandling() {
        return true;
    }

    public FormChangeProcessor getChangeProcessor() {
        return this.changeProcessor;
    }

    public CommandResponse actionProcess(CommandRequest request) throws Exception {
        String modifiedFieldName = request.getParameter("modifiedFieldName");
        FormNamespaceData formNamespaceData = NamespaceManager.lookup().getNamespace(modifiedFieldName);
        FormChangeResponse changeResponse = new FormChangeResponse();
        while (formNamespaceData != null && formNamespaceData.getForm() != null) {
            if (this.getChangeProcessor() != null) {
                this.formProcessor.setValues(formNamespaceData.getForm(), formNamespaceData.getNamespace(), request.getRequestObject().getParameterMap(), request.getFilesByParamName(), false);
                this.getChangeProcessor().process(formNamespaceData.getForm(), formNamespaceData.getNamespace(), changeResponse);
                this.formProcessor.clearFieldErrors(formNamespaceData.getForm(), formNamespaceData.getNamespace());
            }
            formNamespaceData = NamespaceManager.lookup().getNamespace(formNamespaceData.getNamespace());
        }
        request.getResponseObject().setContentType("text/xml");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending form change response " + changeResponse.getXML());
        }
        request.getResponseObject().getWriter().write(changeResponse.getXML());
        return new DoNothingResponse();
    }
}

