/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.history;

import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import java.util.StringTokenizer;
import org.gwt.mosaic.ui.client.DecoratedTabLayoutPanel;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ScrollLayoutPanel;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.WidgetWindowPanel;
import org.jboss.bpm.console.client.history.LoadProcessInstanceEventsAction;
import org.jboss.bpm.console.client.model.HistoryProcessInstanceRef;
import org.jboss.bpm.console.client.model.StringRef;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.framework.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessHistoryInstanceListView
implements ViewInterface,
WidgetProvider,
DataDriven {
    public static final String ID = ProcessHistoryInstanceListView.class.getName();
    private Controller controller;
    private MosaicPanel panel;
    private MosaicPanel instanceList;
    private ListBox<HistoryProcessInstanceRef> listbox;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private WidgetWindowPanel processEventsWindow;
    private ListBox<String> processEvents;
    private String selectedProcessInstanceId;

    public void provideWidget(ProvisioningCallback callback) {
        this.controller = (Controller)Registry.get(Controller.class);
        this.controller.addView(ID, (ViewInterface)this);
        this.controller.addAction(LoadProcessInstanceEventsAction.ID, (ActionInterface)new LoadProcessInstanceEventsAction());
        this.panel = new MosaicPanel();
        this.panel.setPadding(0);
        this.panel.setWidgetSpacing(5);
        this.instanceList = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        this.instanceList.setPadding(0);
        this.instanceList.setWidgetSpacing(5);
        this.listbox = new ListBox(new String[]{"Instance Id", "Correlation Key", "Status", "Start Time", "Finish Time"});
        this.listbox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.listbox.addDoubleClickHandler((DoubleClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.instanceList.add((Widget)this.listbox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.panel.add((Widget)this.instanceList);
        callback.onSuccess((Widget)this.panel);
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void reset() {
    }

    public void update(Object ... data) {
        List result = (List)data[0];
        DefaultListModel model = (DefaultListModel)this.listbox.getModel();
        model.clear();
        for (HistoryProcessInstanceRef ref : result) {
            model.add((Object)ref);
        }
        this.panel.invalidate();
    }

    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.instanceList, (boolean)isLoading);
    }

    public void createHistoryInstanceDetailWindow() {
        ScrollLayoutPanel layout = new ScrollLayoutPanel();
        layout.setStyleName("bpm-window-layout");
        layout.setPadding(5);
        Label header = new Label("Instance: " + this.selectedProcessInstanceId);
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        DecoratedTabLayoutPanel tabPanel = new DecoratedTabLayoutPanel(false);
        tabPanel.setPadding(5);
        this.processEvents = new ListBox(new String[]{"Process Events"});
        this.processEvents.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        MosaicPanel sourcePanel = new MosaicPanel();
        sourcePanel.add((Widget)this.processEvents, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.VERTICAL));
        tabPanel.add((Widget)sourcePanel, "Activity Events");
        tabPanel.selectTab(0);
        layout.add((Widget)tabPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.processEventsWindow = new WidgetWindowPanel("History Instance Activity", (Widget)layout, true);
        this.controller.handleEvent(new Event(LoadProcessInstanceEventsAction.ID, (Object)this.selectedProcessInstanceId));
    }

    public void populateInstanceEvents(List<StringRef> refs) {
        DefaultListModel model = (DefaultListModel)this.processEvents.getModel();
        model.clear();
        for (StringRef value : refs) {
            model.add((Object)this.formatResult(value.getValue()));
        }
    }

    private String formatResult(String value) {
        StringBuffer sbuffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(value, "~");
        sbuffer.append(st.nextToken() + " : ");
        while (st.hasMoreTokens()) {
            sbuffer.append("<br/>");
            sbuffer.append(st.nextToken());
        }
        return sbuffer.toString();
    }

    static /* synthetic */ SimpleDateFormat access$000(ProcessHistoryInstanceListView x0) {
        return x0.dateFormat;
    }

    static /* synthetic */ ListBox access$100(ProcessHistoryInstanceListView x0) {
        return x0.listbox;
    }

    static /* synthetic */ String access$202(ProcessHistoryInstanceListView x0, String x1) {
        x0.selectedProcessInstanceId = x1;
        return x0.selectedProcessInstanceId;
    }
}

