/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit;

import java.util.Date;
import java.util.Map;
import org.jbpm.services.task.audit.impl.model.GroupAuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.HistoryAuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.jbpm.services.task.audit.impl.model.UserAuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.api.GroupAuditTask;
import org.jbpm.services.task.audit.impl.model.api.UserAuditTask;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.TaskEvent;

public class JPATaskLifeCycleEventListener
implements TaskLifeCycleEventListener {
    public void afterTaskStartedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.STARTED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        if (task != null) {
            task.setStatus(ti.getTaskData().getStatus().name());
            persistenceContext.persist((Object)task);
        }
    }

    public void afterTaskActivatedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.ACTIVATED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        task.setStatus(ti.getTaskData().getStatus().name());
        persistenceContext.persist((Object)task);
    }

    public void afterTaskClaimedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.CLAIMED, userId, new Date()));
        GroupAuditTask task = (GroupAuditTask)persistenceContext.queryWithParametersInTransaction("getGroupAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(GroupAuditTask.class));
        if (task != null) {
            persistenceContext.remove((Object)task);
        }
        persistenceContext.persist((Object)new UserAuditTaskImpl(userId, ti.getId(), ti.getTaskData().getStatus().name(), ti.getTaskData().getActivationTime(), ((I18NText)ti.getNames().get(0)).getText(), !ti.getDescriptions().isEmpty() ? ((I18NText)ti.getDescriptions().get(0)).getText() : "", ti.getPriority(), ti.getTaskData().getCreatedBy() == null ? "" : ti.getTaskData().getCreatedBy().getId(), ti.getTaskData().getCreatedOn(), ti.getTaskData().getExpirationTime(), ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getProcessId(), ti.getTaskData().getProcessSessionId(), ti.getTaskData().getParentId()));
    }

    public void afterTaskSkippedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.SKIPPED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        if (task != null) {
            persistenceContext.remove((Object)task);
            HistoryAuditTaskImpl historyAuditTaskImpl = new HistoryAuditTaskImpl(task.getActualOwner(), task.getTaskId(), ti.getTaskData().getStatus().name(), task.getActivationTime(), task.getName(), task.getDescription(), task.getPriority(), task.getCreatedBy(), task.getCreatedOn(), task.getDueDate(), task.getProcessInstanceId(), task.getProcessId(), task.getProcessSessionId(), task.getParentId());
            persistenceContext.persist((Object)historyAuditTaskImpl);
        } else {
            GroupAuditTask groupTask = (GroupAuditTask)persistenceContext.queryWithParametersInTransaction("getGroupAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(GroupAuditTask.class));
            if (groupTask != null) {
                persistenceContext.remove((Object)groupTask);
                HistoryAuditTaskImpl historyAuditTaskImpl = new HistoryAuditTaskImpl(groupTask.getPotentialOwners(), groupTask.getTaskId(), ti.getTaskData().getStatus().name(), groupTask.getActivationTime(), groupTask.getName(), groupTask.getDescription(), groupTask.getPriority(), groupTask.getCreatedBy(), groupTask.getCreatedOn(), groupTask.getDueDate(), groupTask.getProcessInstanceId(), groupTask.getProcessId(), groupTask.getProcessSessionId(), groupTask.getParentId());
                persistenceContext.persist((Object)historyAuditTaskImpl);
            }
        }
    }

    public void afterTaskStoppedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.STOPPED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        if (task != null) {
            persistenceContext.remove((Object)task);
            HistoryAuditTaskImpl historyAuditTaskImpl = new HistoryAuditTaskImpl(task.getActualOwner(), task.getTaskId(), ti.getTaskData().getStatus().name(), task.getActivationTime(), task.getName(), task.getDescription(), task.getPriority(), task.getCreatedBy(), task.getCreatedOn(), task.getDueDate(), task.getProcessInstanceId(), task.getProcessId(), task.getProcessSessionId(), task.getParentId());
            persistenceContext.persist((Object)historyAuditTaskImpl);
        } else {
            GroupAuditTask groupTask = (GroupAuditTask)persistenceContext.queryWithParametersInTransaction("getGroupAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(GroupAuditTask.class));
            if (groupTask != null) {
                persistenceContext.remove((Object)groupTask);
                HistoryAuditTaskImpl historyAuditTaskImpl = new HistoryAuditTaskImpl(groupTask.getPotentialOwners(), groupTask.getTaskId(), ti.getTaskData().getStatus().name(), groupTask.getActivationTime(), groupTask.getName(), groupTask.getDescription(), groupTask.getPriority(), groupTask.getCreatedBy(), groupTask.getCreatedOn(), groupTask.getDueDate(), groupTask.getProcessInstanceId(), groupTask.getProcessId(), groupTask.getProcessSessionId(), groupTask.getParentId());
                persistenceContext.persist((Object)historyAuditTaskImpl);
            }
        }
    }

    public void afterTaskCompletedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.COMPLETED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        if (task != null) {
            persistenceContext.remove((Object)task);
            HistoryAuditTaskImpl historyAuditTaskImpl = new HistoryAuditTaskImpl(task.getActualOwner(), task.getTaskId(), ti.getTaskData().getStatus().name(), task.getActivationTime(), task.getName(), task.getDescription(), task.getPriority(), task.getCreatedBy(), task.getCreatedOn(), task.getDueDate(), task.getProcessInstanceId(), task.getProcessId(), task.getProcessSessionId(), task.getParentId());
            persistenceContext.persist((Object)historyAuditTaskImpl);
        }
    }

    public void afterTaskFailedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.FAILED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        if (task != null) {
            persistenceContext.remove((Object)task);
            HistoryAuditTaskImpl historyAuditTaskImpl = new HistoryAuditTaskImpl(task.getActualOwner(), task.getTaskId(), ti.getTaskData().getStatus().name(), task.getActivationTime(), task.getName(), task.getDescription(), task.getPriority(), task.getCreatedBy(), task.getCreatedOn(), task.getDueDate(), task.getProcessInstanceId(), task.getProcessId(), task.getProcessSessionId(), task.getParentId());
            persistenceContext.persist((Object)historyAuditTaskImpl);
        } else {
            GroupAuditTask groupTask = (GroupAuditTask)persistenceContext.queryWithParametersInTransaction("getGroupAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(GroupAuditTask.class));
            if (groupTask != null) {
                persistenceContext.remove((Object)groupTask);
                HistoryAuditTaskImpl historyAuditTaskImpl = new HistoryAuditTaskImpl(groupTask.getPotentialOwners(), groupTask.getTaskId(), ti.getTaskData().getStatus().name(), groupTask.getActivationTime(), groupTask.getName(), groupTask.getDescription(), groupTask.getPriority(), groupTask.getCreatedBy(), groupTask.getCreatedOn(), groupTask.getDueDate(), groupTask.getProcessInstanceId(), groupTask.getProcessId(), groupTask.getProcessSessionId(), groupTask.getParentId());
                persistenceContext.persist((Object)historyAuditTaskImpl);
            }
        }
    }

    public void afterTaskAddedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
            persistenceContext.persist((Object)new UserAuditTaskImpl(userId, ti.getId(), ti.getTaskData().getStatus().name(), ti.getTaskData().getActivationTime(), ((I18NText)ti.getNames().get(0)).getText(), !ti.getDescriptions().isEmpty() ? ((I18NText)ti.getDescriptions().get(0)).getText() : "", ti.getPriority(), ti.getTaskData().getCreatedBy() == null ? "" : ti.getTaskData().getCreatedBy().getId(), ti.getTaskData().getCreatedOn(), ti.getTaskData().getExpirationTime(), ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getProcessId(), ti.getTaskData().getProcessSessionId(), ti.getTaskData().getParentId()));
        } else if (!ti.getPeopleAssignments().getPotentialOwners().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (OrganizationalEntity o : ti.getPeopleAssignments().getPotentialOwners()) {
                sb.append(o.getId()).append("|");
            }
            persistenceContext.persist((Object)new GroupAuditTaskImpl(sb.toString(), ti.getId(), ti.getTaskData().getStatus().name(), ti.getTaskData().getActivationTime(), ((I18NText)ti.getNames().get(0)).getText(), !ti.getDescriptions().isEmpty() ? ((I18NText)ti.getDescriptions().get(0)).getText() : "", ti.getPriority(), ti.getTaskData().getCreatedBy() == null ? "" : ti.getTaskData().getCreatedBy().getId(), ti.getTaskData().getCreatedOn(), ti.getTaskData().getExpirationTime(), ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getProcessId(), ti.getTaskData().getProcessSessionId(), ti.getTaskData().getParentId()));
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.ADDED, userId, new Date()));
    }

    public void afterTaskExitedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.EXITED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        if (task != null) {
            persistenceContext.remove((Object)task);
            HistoryAuditTaskImpl historyAuditTaskImpl = new HistoryAuditTaskImpl(task.getActualOwner(), task.getTaskId(), ti.getTaskData().getStatus().name(), task.getActivationTime(), task.getName(), task.getDescription(), task.getPriority(), task.getCreatedBy(), task.getCreatedOn(), task.getDueDate(), task.getProcessInstanceId(), task.getProcessId(), task.getProcessSessionId(), task.getParentId());
            persistenceContext.persist((Object)historyAuditTaskImpl);
        } else {
            GroupAuditTask groupTask = (GroupAuditTask)persistenceContext.queryWithParametersInTransaction("getGroupAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(GroupAuditTask.class));
            if (groupTask != null) {
                persistenceContext.remove((Object)groupTask);
                HistoryAuditTaskImpl historyAuditTaskImpl = new HistoryAuditTaskImpl(groupTask.getPotentialOwners(), groupTask.getTaskId(), ti.getTaskData().getStatus().name(), groupTask.getActivationTime(), groupTask.getName(), groupTask.getDescription(), groupTask.getPriority(), groupTask.getCreatedBy(), groupTask.getCreatedOn(), groupTask.getDueDate(), groupTask.getProcessInstanceId(), groupTask.getProcessId(), groupTask.getProcessSessionId(), groupTask.getParentId());
                persistenceContext.persist((Object)historyAuditTaskImpl);
            }
        }
    }

    public void afterTaskReleasedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.RELEASED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        if (task != null) {
            persistenceContext.remove((Object)task);
        }
        StringBuilder sb = new StringBuilder();
        for (OrganizationalEntity o : ti.getPeopleAssignments().getPotentialOwners()) {
            sb.append(o.getId()).append("|");
        }
        persistenceContext.persist((Object)new GroupAuditTaskImpl(sb.toString(), ti.getId(), ti.getTaskData().getStatus().name(), ti.getTaskData().getActivationTime(), ((I18NText)ti.getNames().get(0)).getText(), !ti.getDescriptions().isEmpty() ? ((I18NText)ti.getDescriptions().get(0)).getText() : "", ti.getPriority(), ti.getTaskData().getCreatedBy() == null ? "" : ti.getTaskData().getCreatedBy().getId(), ti.getTaskData().getCreatedOn(), ti.getTaskData().getExpirationTime(), ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getProcessId(), ti.getTaskData().getProcessSessionId(), ti.getTaskData().getParentId()));
    }

    public void afterTaskResumedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.RESUMED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        task.setStatus(ti.getTaskData().getStatus().name());
        persistenceContext.persist((Object)task);
    }

    public void afterTaskSuspendedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.SUSPENDED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        task.setStatus(ti.getTaskData().getStatus().name());
        persistenceContext.persist((Object)task);
    }

    public void afterTaskForwardedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.FORWARDED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        task.setStatus(ti.getTaskData().getStatus().name());
        persistenceContext.persist((Object)task);
    }

    public void afterTaskDelegatedEvent(TaskEvent event) {
        String userId = "";
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.DELEGATED, userId, new Date()));
        UserAuditTask task = (UserAuditTask)persistenceContext.queryWithParametersInTransaction("getUserAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(UserAuditTask.class));
        if (task != null) {
            persistenceContext.remove((Object)task);
        }
        StringBuilder sb = new StringBuilder();
        for (OrganizationalEntity o : ti.getPeopleAssignments().getPotentialOwners()) {
            sb.append(o.getId());
        }
        persistenceContext.persist((Object)new GroupAuditTaskImpl(sb.toString(), ti.getId(), ti.getTaskData().getStatus().name(), ti.getTaskData().getActivationTime(), ((I18NText)ti.getNames().get(0)).getText(), !ti.getDescriptions().isEmpty() ? ((I18NText)ti.getDescriptions().get(0)).getText() : "", ti.getPriority(), ti.getTaskData().getCreatedBy() == null ? "" : ti.getTaskData().getCreatedBy().getId(), ti.getTaskData().getCreatedOn(), ti.getTaskData().getExpirationTime(), ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getProcessId(), ti.getTaskData().getProcessSessionId(), ti.getTaskData().getParentId()));
    }

    public void beforeTaskActivatedEvent(TaskEvent event) {
    }

    public void beforeTaskClaimedEvent(TaskEvent event) {
    }

    public void beforeTaskSkippedEvent(TaskEvent event) {
    }

    public void beforeTaskStartedEvent(TaskEvent event) {
    }

    public void beforeTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskCompletedEvent(TaskEvent event) {
    }

    public void beforeTaskFailedEvent(TaskEvent event) {
    }

    public void beforeTaskAddedEvent(TaskEvent event) {
    }

    public void beforeTaskExitedEvent(TaskEvent event) {
    }

    public void beforeTaskReleasedEvent(TaskEvent event) {
    }

    public void beforeTaskResumedEvent(TaskEvent event) {
    }

    public void beforeTaskSuspendedEvent(TaskEvent event) {
    }

    public void beforeTaskForwardedEvent(TaskEvent event) {
    }

    public void beforeTaskDelegatedEvent(TaskEvent event) {
    }
}

