/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.lifecycle.listeners;

import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.jbpm.services.task.audit.impl.model.BAMTaskSummaryImpl;
import org.jbpm.services.task.persistence.PersistableEventListener;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BAMTaskEventListener
extends PersistableEventListener {
    private static final Logger logger = LoggerFactory.getLogger(BAMTaskEventListener.class);

    public BAMTaskEventListener(boolean flag) {
        super(null);
    }

    public BAMTaskEventListener(EntityManagerFactory emf) {
        super(emf);
    }

    public void afterTaskStartedEvent(final TaskEvent event) {
        this.updateTask(event, new BAMTaskWorker(){

            @Override
            public BAMTaskSummaryImpl createTask(BAMTaskSummaryImpl bamTask, Task task) {
                bamTask.setStartDate(event.getEventDate());
                return bamTask;
            }

            @Override
            public BAMTaskSummaryImpl updateTask(BAMTaskSummaryImpl bamTask, Task task) {
                bamTask.setStartDate(event.getEventDate());
                return bamTask;
            }
        });
    }

    public void afterTaskActivatedEvent(TaskEvent event) {
        this.updateTask(event);
    }

    public void afterTaskClaimedEvent(TaskEvent event) {
        this.updateTask(event);
    }

    public void afterTaskCompletedEvent(final TaskEvent event) {
        this.updateTask(event, new BAMTaskWorker(){

            @Override
            public BAMTaskSummaryImpl createTask(BAMTaskSummaryImpl bamTask, Task task) {
                return bamTask;
            }

            @Override
            public BAMTaskSummaryImpl updateTask(BAMTaskSummaryImpl bamTask, Task task) {
                Date completedDate = event.getEventDate();
                bamTask.setEndDate(completedDate);
                bamTask.setDuration(completedDate.getTime() - bamTask.getStartDate().getTime());
                return bamTask;
            }
        });
    }

    public void afterTaskAddedEvent(TaskEvent event) {
        this.createTask(event, null, null);
    }

    public void afterTaskSkippedEvent(TaskEvent event) {
        this.createOrUpdateTask(event, Status.Obsolete);
    }

    public void afterTaskStoppedEvent(TaskEvent event) {
        this.updateTask(event);
    }

    public void afterTaskFailedEvent(TaskEvent event) {
        this.createOrUpdateTask(event, Status.Failed);
    }

    public void afterTaskExitedEvent(TaskEvent event) {
        this.createOrUpdateTask(event, Status.Exited);
    }

    public void afterTaskReleasedEvent(TaskEvent event) {
        this.updateTask(event);
    }

    public void afterTaskDelegatedEvent(TaskEvent event) {
        this.updateTask(event);
    }

    public void afterTaskForwaredEvent(TaskEvent event) {
        this.updateTask(event);
    }

    public void afterTaskNomiatedEvent(TaskEvent event) {
        this.updateTask(event);
    }

    public void afterTaskResumedEvent(TaskEvent event) {
        this.updateTask(event);
    }

    public void afterTaskSuspendedEvent(TaskEvent event) {
        this.updateTask(event);
    }

    public void afterTaskForwardedEvent(TaskEvent event) {
        this.updateTask(event);
    }

    public void afterTaskNominatedEvent(TaskEvent event) {
        this.updateTask(event);
    }

    protected BAMTaskSummaryImpl updateTask(TaskEvent event, BAMTaskWorker worker) {
        return this.updateTask(event, null, worker);
    }

    protected BAMTaskSummaryImpl updateTask(TaskEvent event) {
        return this.updateTask(event, null, null);
    }

    protected BAMTaskSummaryImpl createOrUpdateTask(TaskEvent event, Status newStatus) {
        return this.updateTask(event, newStatus, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BAMTaskSummaryImpl createTask(TaskEvent event, Status newStatus, BAMTaskWorker worker) {
        BAMTaskSummaryImpl result = null;
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            if (ti == null) {
                logger.error("The task instance does not exist.");
                BAMTaskSummaryImpl bAMTaskSummaryImpl = result;
                return bAMTaskSummaryImpl;
            }
            Status status = newStatus != null ? newStatus : ti.getTaskData().getStatus();
            String actualOwner = "";
            if (ti.getTaskData().getActualOwner() != null) {
                actualOwner = ti.getTaskData().getActualOwner().getId();
            }
            result = new BAMTaskSummaryImpl(ti.getId(), ti.getName(), status.toString(), event.getEventDate(), actualOwner, ti.getTaskData().getProcessInstanceId());
            if (worker != null) {
                worker.createTask(result, ti);
            }
            persistenceContext.persist((Object)result);
            BAMTaskSummaryImpl bAMTaskSummaryImpl = result;
            return bAMTaskSummaryImpl;
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BAMTaskSummaryImpl updateTask(TaskEvent event, Status newStatus, BAMTaskWorker worker) {
        BAMTaskSummaryImpl result = null;
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            if (ti == null) {
                logger.error("The task instance does not exist.");
                BAMTaskSummaryImpl bAMTaskSummaryImpl = result;
                return bAMTaskSummaryImpl;
            }
            Status status = newStatus != null ? newStatus : ti.getTaskData().getStatus();
            result = (BAMTaskSummaryImpl)persistenceContext.queryStringWithParametersInTransaction("select bts from BAMTaskSummaryImpl bts where bts.taskId=:taskId", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), BAMTaskSummaryImpl.class);
            if (result == null) {
                logger.warn("Unable find bam task entry for task id {} '{}', skipping bam task update", (Object)ti.getId(), (Object)ti.getName());
                BAMTaskSummaryImpl bAMTaskSummaryImpl = null;
                return bAMTaskSummaryImpl;
            }
            result.setStatus(status.toString());
            if (ti.getTaskData().getActualOwner() != null) {
                result.setUserId(ti.getTaskData().getActualOwner().getId());
            }
            if (worker != null) {
                worker.updateTask(result, ti);
            }
            persistenceContext.merge((Object)result);
            BAMTaskSummaryImpl bAMTaskSummaryImpl = result;
            return bAMTaskSummaryImpl;
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    public void beforeTaskActivatedEvent(TaskEvent event) {
    }

    public void beforeTaskClaimedEvent(TaskEvent event) {
    }

    public void beforeTaskSkippedEvent(TaskEvent event) {
    }

    public void beforeTaskStartedEvent(TaskEvent event) {
    }

    public void beforeTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskCompletedEvent(TaskEvent event) {
    }

    public void beforeTaskFailedEvent(TaskEvent event) {
    }

    public void beforeTaskAddedEvent(TaskEvent event) {
    }

    public void beforeTaskExitedEvent(TaskEvent event) {
    }

    public void beforeTaskReleasedEvent(TaskEvent event) {
    }

    public void beforeTaskResumedEvent(TaskEvent event) {
    }

    public void beforeTaskSuspendedEvent(TaskEvent event) {
    }

    public void beforeTaskForwardedEvent(TaskEvent event) {
    }

    public void beforeTaskDelegatedEvent(TaskEvent event) {
    }

    public void beforeTaskNominatedEvent(TaskEvent event) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof BAMTaskEventListener;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)((Object)this)).getClass().getName().hashCode();
        return result;
    }

    private class BAMSummaryComparator
    implements Comparator<BAMTaskSummaryImpl> {
        private BAMSummaryComparator() {
        }

        @Override
        public int compare(BAMTaskSummaryImpl o1, BAMTaskSummaryImpl o2) {
            return o1.getTaskId() < o2.getTaskId() ? -1 : (o1.getTaskId() == o2.getTaskId() ? 0 : 1);
        }
    }

    protected static interface BAMTaskWorker {
        public BAMTaskSummaryImpl createTask(BAMTaskSummaryImpl var1, Task var2);

        public BAMTaskSummaryImpl updateTask(BAMTaskSummaryImpl var1, Task var2);
    }
}

