/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.util.Date;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.query.AbstractAuditDeleteBuilderImpl;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.kie.api.runtime.CommandExecutor;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.task.query.TaskEventDeleteBuilder;

public class TaskEventDeleteBuilderImpl
extends AbstractAuditDeleteBuilderImpl<TaskEventDeleteBuilder>
implements TaskEventDeleteBuilder {
    private static String TASK_EVENT_IMPL_DELETE = "DELETE\nFROM TaskEventImpl l\n";

    public TaskEventDeleteBuilderImpl(CommandExecutor cmdExecutor) {
        super(cmdExecutor);
        this.intersect();
    }

    public TaskEventDeleteBuilderImpl(JPAAuditLogService jpaAuditService) {
        super(jpaAuditService);
        this.intersect();
    }

    public TaskEventDeleteBuilder date(Date ... date) {
        if (this.checkIfNull(date)) {
            return this;
        }
        this.addObjectParameter(QueryParameterIdentifiers.TASK_EVENT_DATE_ID_LIST, "created on date", this.ensureDateNotTimestamp(date));
        return this;
    }

    public TaskEventDeleteBuilder dateRangeStart(Date rangeStart) {
        if (this.checkIfNull(new Date[]{rangeStart})) {
            return this;
        }
        this.addRangeParameter(QueryParameterIdentifiers.TASK_EVENT_DATE_ID_LIST, "created on date range end", this.ensureDateNotTimestamp(new Date[]{rangeStart})[0], true);
        return this;
    }

    public TaskEventDeleteBuilder dateRangeEnd(Date rangeStart) {
        if (this.checkIfNull(new Date[]{rangeStart})) {
            return this;
        }
        this.addRangeParameter(QueryParameterIdentifiers.TASK_EVENT_DATE_ID_LIST, "created on date range end", this.ensureDateNotTimestamp(new Date[]{rangeStart})[0], false);
        return this;
    }

    protected Class getQueryType() {
        return TaskEventImpl.class;
    }

    protected String getQueryBase() {
        return TASK_EVENT_IMPL_DELETE;
    }

    protected boolean isSubquerySupported() {
        return true;
    }
}

