/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.impl.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.kie.internal.task.api.AuditTask;

@Entity
@Table(name="AuditTaskImpl", indexes={@Index(name="IDX_AuditTaskImpl_taskId", columnList="taskId"), @Index(name="IDX_AuditTaskImpl_pInstId", columnList="processInstanceId"), @Index(name="IDX_AuditTaskImpl_workItemId", columnList="workItemId"), @Index(name="IDX_AuditTaskImpl_name", columnList="name"), @Index(name="IDX_AuditTaskImpl_processId", columnList="processId"), @Index(name="IDX_AuditTaskImpl_status", columnList="status")})
@SequenceGenerator(name="auditIdSeq", sequenceName="AUDIT_ID_SEQ", allocationSize=1)
public class AuditTaskImpl
implements Serializable,
AuditTask {
    private static final long serialVersionUID = 5388016330549830043L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="auditIdSeq")
    private Long id;
    private Long taskId;
    private String status;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date activationTime;
    private String name;
    private String description;
    private int priority;
    private String createdBy;
    private String actualOwner;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dueDate;
    private long processInstanceId;
    private String processId;
    private long processSessionId;
    private long parentId;
    private String deploymentId;
    private Long workItemId;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModificationDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="end_date")
    private Date end;

    public AuditTaskImpl() {
    }

    public AuditTaskImpl(long taskId, String name, String status, Date activationTime, String actualOwner, String description, int priority, String createdBy, Date createdOn, Date dueDate, long processInstanceId, String processId, long processSessionId, String deploymentId, long parentId, long workItemId) {
        this.taskId = taskId;
        this.status = status;
        this.activationTime = activationTime;
        this.name = name;
        this.description = description;
        this.priority = priority;
        this.createdBy = createdBy;
        this.createdOn = createdOn;
        this.actualOwner = actualOwner;
        this.dueDate = dueDate;
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.processSessionId = processSessionId;
        this.deploymentId = deploymentId;
        this.parentId = parentId;
        this.workItemId = workItemId;
        this.lastModificationDate = new Date();
    }

    public AuditTaskImpl(long taskId, String name, String status, Date activationTime, String actualOwner, String description, int priority, String createdBy, Date createdOn, Date dueDate, long processInstanceId, String processId, long processSessionId, String deploymentId, long parentId, long workItemId, Date lastModificationDate) {
        this.taskId = taskId;
        this.status = status;
        this.activationTime = activationTime;
        this.name = name;
        this.description = description;
        this.priority = priority;
        this.createdBy = createdBy;
        this.createdOn = createdOn;
        this.actualOwner = actualOwner;
        this.dueDate = dueDate;
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.processSessionId = processSessionId;
        this.deploymentId = deploymentId;
        this.parentId = parentId;
        this.workItemId = workItemId;
        this.lastModificationDate = lastModificationDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public long getProcessSessionId() {
        return this.processSessionId;
    }

    public void setProcessSessionId(long processSessionId) {
        this.processSessionId = processSessionId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public String getActualOwner() {
        return this.actualOwner;
    }

    public void setActualOwner(String actualOwner) {
        this.actualOwner = actualOwner;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public void setWorkItemId(long workItemId) {
        this.workItemId = workItemId;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(Date lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activationTime == null ? 0 : this.activationTime.hashCode());
        result = 31 * result + (this.actualOwner == null ? 0 : this.actualOwner.hashCode());
        result = 31 * result + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = 31 * result + (this.createdOn == null ? 0 : this.createdOn.hashCode());
        result = 31 * result + (this.deploymentId == null ? 0 : this.deploymentId.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.dueDate == null ? 0 : this.dueDate.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lastModificationDate == null ? 0 : this.lastModificationDate.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.parentId ^ this.parentId >>> 32);
        result = 31 * result + this.priority;
        result = 31 * result + (this.processId == null ? 0 : this.processId.hashCode());
        result = 31 * result + (int)(this.processInstanceId ^ this.processInstanceId >>> 32);
        result = 31 * result + (int)(this.processSessionId ^ this.processSessionId >>> 32);
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        result = 31 * result + (this.workItemId == null ? 0 : this.workItemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditTaskImpl other = (AuditTaskImpl)obj;
        if (this.activationTime == null ? other.activationTime != null : !this.activationTime.equals(other.activationTime)) {
            return false;
        }
        if (this.actualOwner == null ? other.actualOwner != null : !this.actualOwner.equals(other.actualOwner)) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.createdOn == null ? other.createdOn != null : !this.createdOn.equals(other.createdOn)) {
            return false;
        }
        if (this.deploymentId == null ? other.deploymentId != null : !this.deploymentId.equals(other.deploymentId)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.dueDate == null ? other.dueDate != null : !this.dueDate.equals(other.dueDate)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lastModificationDate == null ? other.lastModificationDate != null : !this.lastModificationDate.equals(other.lastModificationDate)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parentId != other.parentId) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (this.processInstanceId != other.processInstanceId) {
            return false;
        }
        if (this.processSessionId != other.processSessionId) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId)) {
            return false;
        }
        return !(this.workItemId == null ? other.workItemId != null : !this.workItemId.equals(other.workItemId));
    }

    public String toString() {
        return "AuditTaskImpl [id=" + this.id + ", taskId=" + this.taskId + ", status=" + this.status + ", activationTime=" + this.activationTime + ", name=" + this.name + ", description=" + this.description + ", priority=" + this.priority + ", createdBy=" + this.createdBy + ", actualOwner=" + this.actualOwner + ", createdOn=" + this.createdOn + ", dueDate=" + this.dueDate + ", processInstanceId=" + this.processInstanceId + ", processId=" + this.processId + ", processSessionId=" + this.processSessionId + ", parentId=" + this.parentId + ", deploymentId=" + this.deploymentId + ", workItemId=" + this.workItemId + ", lastModificationDate=" + this.lastModificationDate + "]";
    }
}

