/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import org.jbpm.process.audit.ArchiveLoggerProvider;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullHierarchyArchiveLoggerProvider
implements ArchiveLoggerProvider {
    private static final Logger logger = LoggerFactory.getLogger(FullHierarchyArchiveLoggerProvider.class);

    public void archive(EntityManager em, ProcessInstanceLog log) {
        if (log.getParentProcessInstanceId() != null || log.getParentProcessInstanceId() != -1L) {
            log.setEnd(null);
            return;
        }
        long pid = log.getProcessInstanceId();
        Date endDate = log.getEnd();
        List ids = em.createNativeQuery("WITH RECURSIVE CTE AS ( \n    SELECT parent.*, parent.processInstanceId AS group FROM ProcessInstanceLog parent WHERE parent.parentProcessInstanceId IS NULL OR parent.parentProcessInstanceId = -1\n    UNION  ALL\n    SELECT child.*, CTE.group AS group FROM ProcessInstanceLog child INNER JOIN CTE ON child.parentProcessInstanceId = CTE.processInstanceId\n) \nSELECT processInstanceId FROM CTE WHERE CTE.group = :parentProcessInstanceId").setParameter("parentProcessInstanceId", (Object)pid).getResultList();
        int count = em.createQuery("UPDATE ProcessInstanceLog o SET o.end = :endDate WHERE o.processInstanceId IN (:pid)").setParameter("pid", (Object)ids).setParameter("endDate", (Object)endDate).executeUpdate();
        logger.info("Archived {} process instances log for process instance id {}", (Object)count, (Object)ids);
        count = em.createQuery("UPDATE NodeInstanceLog o SET o.end = :endDate WHERE o.processInstanceId IN (:pid)").setParameter("pid", (Object)ids).setParameter("endDate", (Object)endDate).executeUpdate();
        logger.info("Archived {} node instances log for process instance id {}", (Object)count, (Object)ids);
        count = em.createQuery("UPDATE VariableInstanceLog o SET o.end = :endDate WHERE o.processInstanceId IN (:pid)").setParameter("pid", (Object)pid).setParameter("endDate", (Object)endDate).executeUpdate();
        logger.info("Archived {} variable instances log for process instance id {}", (Object)count, (Object)ids);
        count = em.createQuery("UPDATE AuditTaskImpl o SET o.end = :endDate WHERE o.processInstanceId IN (:pid)").setParameter("pid", (Object)pid).setParameter("endDate", (Object)endDate).executeUpdate();
        logger.info("Archived {} AuditTaskImpl for process instance id {}", (Object)count, (Object)ids);
        count = em.createQuery("UPDATE TaskEventImpl o SET o.end = :endDate WHERE o.processInstanceId IN (:pid)").setParameter("pid", (Object)pid).setParameter("endDate", (Object)endDate).executeUpdate();
        logger.debug("Archived {} TaskEventImpl for process instance id {}", (Object)count, (Object)ids);
        count = em.createQuery("UPDATE BAMTaskSummaryImpl o SET o.end = :endDate WHERE o.processInstanceId IN (:pid)").setParameter("pid", (Object)pid).setParameter("endDate", (Object)endDate).executeUpdate();
        logger.info("Archived {} BAMTaskSummaryImpl for process instance id {}", (Object)count, (Object)ids);
    }
}

