/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.persistence;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueryManager {
    public static final String FILTER_KEY = "filter";
    public static final String ORDER_BY_KEY = "orderby";
    public static final String ASCENDING_KEY = "asc";
    public static final String DESCENDING_KEY = "desc";
    private static final Logger logger = LoggerFactory.getLogger(TaskQueryManager.class);
    private Map<String, String> queries = new ConcurrentHashMap<String, String>();
    private static TaskQueryManager instance;

    public static TaskQueryManager get() {
        if (instance == null) {
            instance = new TaskQueryManager();
        }
        return instance;
    }

    protected TaskQueryManager() {
        this.addNamedQueries("META-INF/Taskorm.xml");
    }

    public synchronized void addNamedQueries(String ormFile) {
        try {
            this.parse(ormFile);
        }
        catch (Exception e) {
            logger.debug("TaskQueryManager unable to read Taskorm file due to " + e.getMessage(), (Throwable)e);
            logger.warn("TaskQueryManager unable to read Taskorm file due to " + e.getMessage());
        }
    }

    public String getQuery(String name, Map<String, Object> params) {
        String query = null;
        if (!this.queries.containsKey(name)) {
            return null;
        }
        StringBuffer buf = new StringBuffer(this.queries.get(name));
        if (params != null && params.containsKey(FILTER_KEY)) {
            buf.append(" and " + params.get(FILTER_KEY));
        }
        if (params != null && params.containsKey(ORDER_BY_KEY)) {
            buf.append(" \n ORDER BY " + this.adaptOrderBy((String)params.get(ORDER_BY_KEY)));
            if (params.containsKey(ASCENDING_KEY)) {
                buf.append(" ASC");
            } else if (params.containsKey(DESCENDING_KEY)) {
                buf.append(" DESC");
            }
            query = buf.toString();
        }
        return query;
    }

    protected void parse(String ormFile) throws XMLStreamException {
        String name = null;
        StringBuffer tagContent = new StringBuffer();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(ormFile));
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"named-query".equals(reader.getLocalName())) break;
                    name = reader.getAttributeValue(0);
                    break;
                }
                case 4: {
                    if (name == null) break;
                    tagContent.append(" " + reader.getText().trim());
                    break;
                }
                case 2: {
                    String origQuery;
                    if (!"named-query".equals(reader.getLocalName())) break;
                    String alteredQuery = origQuery = tagContent.toString();
                    int orderByIndex = origQuery.toLowerCase().indexOf("order by");
                    if (orderByIndex != -1) {
                        alteredQuery = origQuery.substring(0, orderByIndex);
                    }
                    this.queries.put(name, alteredQuery);
                    name = null;
                    tagContent = new StringBuffer();
                }
            }
        }
    }

    private String adaptOrderBy(String orderBy) {
        if (orderBy != null) {
            if (orderBy.equals("Task")) {
                return "t.name";
            }
            if (orderBy.equals("Description")) {
                return "t.description";
            }
            if (orderBy.equals("Id")) {
                return "t.id";
            }
            if (orderBy.equals("Priority")) {
                return "t.priority";
            }
            if (orderBy.equals("Status")) {
                return "t.taskData.status";
            }
            if (orderBy.equals("CreatedOn")) {
                return "t.taskData.createdOn";
            }
            if (orderBy.equals("CreatedBy")) {
                return "t.taskData.createdBy.id";
            }
            if (orderBy.equals("DueOn")) {
                return "t.taskData.expirationTime";
            }
        }
        return orderBy;
    }
}

