/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;
import org.jbpm.services.task.impl.model.DeadlinesImpl;
import org.jbpm.services.task.impl.model.DelegationImpl;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.utils.CollectionUtils;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.TaskData;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.Delegation;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.SubTasksStrategy;

@Entity
@Table(name="Task")
@SequenceGenerator(name="taskIdSeq", sequenceName="TASK_ID_SEQ", allocationSize=1)
public class TaskImpl
implements InternalTask {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="taskIdSeq")
    @Column(name="id")
    private Long id = 0L;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private int priority;
    private String name;
    private String subject;
    private String description;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=I18NTextImpl.class)
    @JoinColumn(name="Task_Names_Id", nullable=true)
    private List<I18NText> names = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=I18NTextImpl.class)
    @JoinColumn(name="Task_Subjects_Id", nullable=true)
    private List<I18NText> subjects = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=I18NTextImpl.class)
    @JoinColumn(name="Task_Descriptions_Id", nullable=true)
    private List<I18NText> descriptions = Collections.emptyList();
    @Embedded
    private PeopleAssignmentsImpl peopleAssignments;
    @Embedded
    private DelegationImpl delegation;
    @Embedded
    private TaskDataImpl taskData;
    @Embedded
    private DeadlinesImpl deadlines;
    @Enumerated(value=EnumType.STRING)
    private SubTasksStrategy subTaskStrategy = SubTasksStrategy.NoAction;
    private String taskType;
    private String formName;
    @Basic
    private Short archived = 0;

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeInt(this.priority);
        out.writeShort(this.archived.shortValue());
        if (this.taskType != null) {
            out.writeUTF(this.taskType);
        } else {
            out.writeUTF("");
        }
        out.writeUTF(this.formName);
        out.writeUTF(this.name);
        out.writeUTF(this.subject);
        out.writeUTF(this.description);
        CollectionUtils.writeI18NTextList(this.names, out);
        CollectionUtils.writeI18NTextList(this.subjects, out);
        CollectionUtils.writeI18NTextList(this.descriptions, out);
        if (this.subTaskStrategy != null) {
            out.writeBoolean(true);
            out.writeUTF(this.subTaskStrategy.toString());
        } else {
            out.writeBoolean(false);
        }
        if (this.peopleAssignments != null) {
            out.writeBoolean(true);
            this.peopleAssignments.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.delegation != null) {
            out.writeBoolean(true);
            this.delegation.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.taskData != null) {
            out.writeBoolean(true);
            this.taskData.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.deadlines != null) {
            out.writeBoolean(true);
            this.deadlines.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.priority = in.readInt();
        this.archived = in.readShort();
        this.taskType = in.readUTF();
        this.formName = in.readUTF();
        this.name = in.readUTF();
        this.subject = in.readUTF();
        this.description = in.readUTF();
        this.names = CollectionUtils.readI18NTextList(in);
        this.subjects = CollectionUtils.readI18NTextList(in);
        this.descriptions = CollectionUtils.readI18NTextList(in);
        if (in.readBoolean()) {
            this.subTaskStrategy = SubTasksStrategy.valueOf((String)in.readUTF());
        }
        if (in.readBoolean()) {
            this.peopleAssignments = new PeopleAssignmentsImpl();
            this.peopleAssignments.readExternal(in);
        }
        if (in.readBoolean()) {
            this.delegation = new DelegationImpl();
            this.delegation.readExternal(in);
        }
        if (in.readBoolean()) {
            this.taskData = new TaskDataImpl();
            this.taskData.readExternal(in);
        }
        if (in.readBoolean()) {
            this.deadlines = new DeadlinesImpl();
            this.deadlines.readExternal(in);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Boolean isArchived() {
        if (this.archived == null) {
            return null;
        }
        return this.archived == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived == null ? null : (archived == true ? new Short("1") : new Short("0"));
    }

    public int getVersion() {
        return this.version;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List<I18NText> getNames() {
        return this.names;
    }

    public void setNames(List<I18NText> names) {
        this.names = names;
    }

    public List<I18NText> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<I18NText> subjects) {
        this.subjects = subjects;
    }

    public List<I18NText> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<I18NText> descriptions) {
        this.descriptions = descriptions;
    }

    public PeopleAssignments getPeopleAssignments() {
        return this.peopleAssignments;
    }

    public void setPeopleAssignments(PeopleAssignments peopleAssignments) {
        this.peopleAssignments = (PeopleAssignmentsImpl)peopleAssignments;
    }

    public Delegation getDelegation() {
        return this.delegation;
    }

    public void setDelegation(Delegation delegation) {
        this.delegation = (DelegationImpl)delegation;
    }

    public TaskData getTaskData() {
        return this.taskData;
    }

    public void setTaskData(TaskData taskData) {
        this.taskData = (TaskDataImpl)taskData;
    }

    public Deadlines getDeadlines() {
        return this.deadlines;
    }

    public void setDeadlines(Deadlines deadlines) {
        this.deadlines = (DeadlinesImpl)deadlines;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.version;
        result = 31 * result + this.priority;
        result = 31 * result + this.archived.hashCode();
        result = 31 * result + (this.taskType == null ? 0 : this.taskType.hashCode());
        result = 31 * result + CollectionUtils.hashCode(this.descriptions);
        result = 31 * result + CollectionUtils.hashCode(this.names);
        result = 31 * result + CollectionUtils.hashCode(this.subjects);
        result = 31 * result + (this.peopleAssignments == null ? 0 : this.peopleAssignments.hashCode());
        result = 31 * result + (this.delegation == null ? 0 : this.delegation.hashCode());
        result = 31 * result + (this.taskData == null ? 0 : this.taskData.hashCode());
        result = 31 * result + (this.deadlines == null ? 0 : this.deadlines.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskImpl)) {
            return false;
        }
        TaskImpl other = (TaskImpl)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.archived != other.archived) {
            return false;
        }
        if (this.taskType == null ? other.taskType != null : !this.taskType.equals(other.taskType)) {
            return false;
        }
        if (this.deadlines == null) {
            if (other.deadlines != null) {
                // empty if block
            }
        } else if (!this.deadlines.equals(other.deadlines)) {
            return false;
        }
        if (this.delegation == null ? other.delegation != null : !this.delegation.equals(other.delegation)) {
            return false;
        }
        if (this.peopleAssignments == null ? other.peopleAssignments != null : !this.peopleAssignments.equals(other.peopleAssignments)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.taskData == null ? other.taskData != null : !this.taskData.equals(other.taskData)) {
            return false;
        }
        return CollectionUtils.equals(this.descriptions, other.descriptions) && CollectionUtils.equals(this.names, other.names) && CollectionUtils.equals(this.subjects, other.subjects);
    }

    public SubTasksStrategy getSubTaskStrategy() {
        return this.subTaskStrategy;
    }

    public void setSubTaskStrategy(SubTasksStrategy subTaskStrategy) {
        this.subTaskStrategy = subTaskStrategy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

