/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.persistence;

import java.lang.reflect.Constructor;
import java.util.Collection;
import org.drools.core.command.CommandService;
import org.drools.core.command.Interceptor;
import org.drools.core.command.impl.AbstractInterceptor;
import org.drools.persistence.OrderedTransactionSynchronization;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerFactory;
import org.drools.persistence.TransactionManagerHelper;
import org.jbpm.services.task.persistence.JPATaskPersistenceContextManager;
import org.kie.api.command.Command;
import org.kie.api.runtime.Environment;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Task;
import org.kie.internal.command.Context;
import org.kie.internal.command.ContextManager;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.TaskPersistenceContextManager;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.exception.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTransactionInterceptor
extends AbstractInterceptor {
    private static Logger logger = LoggerFactory.getLogger(TaskTransactionInterceptor.class);
    private static String SPRING_TM_CLASSNAME = "org.springframework.transaction.support.AbstractPlatformTransactionManager";
    private CommandService commandService;
    private TransactionManager txm;
    private TaskPersistenceContextManager tpm;
    private boolean eagerDisabled = Boolean.getBoolean("jbpm.ht.eager.disabled");

    public TaskTransactionInterceptor(Environment environment) {
        this.initTransactionManager(environment);
    }

    public synchronized <T> T execute(Command<T> command) {
        boolean transactionOwner = false;
        Object result = null;
        try {
            transactionOwner = this.txm.begin();
            this.tpm.beginCommandScopedEntityManager();
            TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)this.txm, (OrderedTransactionSynchronization)new TaskSynchronizationImpl(this));
            result = this.executeNext(command);
            this.postInit(result);
            this.txm.commit(transactionOwner);
            return (T)result;
        }
        catch (TaskException e) {
            if (transactionOwner) {
                this.rollbackTransaction((Exception)((Object)e), transactionOwner);
                e.setRecoverable(false);
                throw e;
            }
            throw e;
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re, transactionOwner);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1, transactionOwner);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
    }

    private void rollbackTransaction(Exception t1, boolean transactionOwner) {
        try {
            logger.warn("Could not commit session", (Throwable)t1);
            this.txm.rollback(transactionOwner);
        }
        catch (Exception t2) {
            logger.error("Could not rollback", (Throwable)t2);
            throw new RuntimeException("Could not commit session or rollback", t2);
        }
    }

    public void addInterceptor(Interceptor interceptor) {
        interceptor.setNext((CommandService)(this.commandService == null ? this : this.commandService));
        this.commandService = interceptor;
    }

    public Context getContext() {
        final TaskPersistenceContext persistenceContext = this.tpm.getPersistenceContext();
        persistenceContext.joinTransaction();
        return new TaskContext(){

            public void set(String identifier, Object value) {
                TaskTransactionInterceptor.this.txm.putResource((Object)identifier, value);
            }

            public void remove(String identifier) {
            }

            public String getName() {
                return null;
            }

            public ContextManager getContextManager() {
                return null;
            }

            public Object get(String identifier) {
                return TaskTransactionInterceptor.this.txm.getResource((Object)identifier);
            }

            public void setPersistenceContext(TaskPersistenceContext context) {
            }

            public TaskPersistenceContext getPersistenceContext() {
                return persistenceContext;
            }

            public UserGroupCallback getUserGroupCallback() {
                return null;
            }

            public Task loadTaskVariables(Task task) {
                return task;
            }
        };
    }

    public void initTransactionManager(Environment env) {
        Object tm = env.get("org.kie.transaction.TransactionManager");
        if (env.get("org.kie.api.persistence.TaskPersistenceContextManager") != null && env.get("org.kie.transaction.TransactionManager") != null) {
            this.txm = (TransactionManager)tm;
            this.tpm = (TaskPersistenceContextManager)env.get("org.kie.api.persistence.TaskPersistenceContextManager");
        } else {
            if (tm != null && this.isSpringTransactionManager(tm.getClass())) {
                try {
                    logger.debug("Instantiating KieSpringTransactionManager");
                    Class<?> cls = Class.forName("org.kie.spring.persistence.KieSpringTransactionManager");
                    Constructor<?> con = cls.getConstructors()[0];
                    this.txm = (TransactionManager)con.newInstance(tm);
                    env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
                    cls = Class.forName("org.kie.spring.persistence.KieSpringTaskJpaManager");
                    con = cls.getConstructors()[0];
                    this.tpm = (TaskPersistenceContextManager)con.newInstance(env);
                }
                catch (Exception e) {
                    logger.warn("Could not instantiate DroolsSpringTransactionManager");
                    throw new RuntimeException("Could not instantiate org.kie.container.spring.beans.persistence.DroolsSpringTransactionManager", e);
                }
            }
            logger.debug("Instantiating JtaTransactionManager");
            this.txm = TransactionManagerFactory.get().newTransactionManager(env);
            env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
            try {
                this.tpm = new JPATaskPersistenceContextManager(env);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating JPATaskPersistenceContextManager", e);
            }
            env.set("org.kie.api.persistence.TaskPersistenceContextManager", (Object)this.tpm);
            env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
        }
    }

    public boolean isSpringTransactionManager(Class<?> clazz) {
        if (SPRING_TM_CLASSNAME.equals(clazz.getName())) {
            return true;
        }
        if (clazz.getSuperclass() != null) {
            return this.isSpringTransactionManager(clazz.getSuperclass());
        }
        return false;
    }

    private void postInit(Object result) {
        if (result instanceof Task) {
            Task task = (Task)result;
            if (task != null && !this.eagerDisabled) {
                task.getNames().size();
                task.getDescriptions().size();
                task.getSubjects().size();
                task.getPeopleAssignments().getBusinessAdministrators().size();
                task.getPeopleAssignments().getPotentialOwners().size();
                ((InternalPeopleAssignments)task.getPeopleAssignments()).getRecipients().size();
                ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners().size();
                ((InternalPeopleAssignments)task.getPeopleAssignments()).getTaskStakeholders().size();
                task.getTaskData().getAttachments().size();
                task.getTaskData().getComments().size();
                ((InternalTask)task).getDeadlines().getStartDeadlines().size();
                ((InternalTask)task).getDeadlines().getEndDeadlines().size();
            }
        } else if (result instanceof Collection) {
            ((Collection)result).size();
        }
    }

    private static class TaskSynchronizationImpl
    extends OrderedTransactionSynchronization {
        TaskTransactionInterceptor service;

        public TaskSynchronizationImpl(TaskTransactionInterceptor service) {
            super(Integer.valueOf(1), "TaskService-" + ((Object)((Object)service)).toString());
            this.service = service;
        }

        public void afterCompletion(int status) {
            this.service.tpm.endCommandScopedEntityManager();
        }

        public void beforeCompletion() {
        }
    }
}

