/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import org.jbpm.services.task.impl.model.DeadlineImpl;
import org.jbpm.services.task.utils.CollectionUtils;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;

@Embeddable
public class DeadlinesImpl
implements Deadlines {
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=DeadlineImpl.class)
    @JoinColumn(name="Deadlines_StartDeadLine_Id", nullable=true)
    private List<Deadline> startDeadlines = new ArrayList<Deadline>();
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=DeadlineImpl.class)
    @JoinColumn(name="Deadlines_EndDeadLine_Id", nullable=true)
    private List<Deadline> endDeadlines = new ArrayList<Deadline>();

    public void writeExternal(ObjectOutput out) throws IOException {
        CollectionUtils.writeDeadlineList(this.startDeadlines, out);
        CollectionUtils.writeDeadlineList(this.endDeadlines, out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startDeadlines = CollectionUtils.readDeadlinesList(in);
        this.endDeadlines = CollectionUtils.readDeadlinesList(in);
    }

    public List<Deadline> getStartDeadlines() {
        return this.startDeadlines;
    }

    public void setStartDeadlines(List<Deadline> startDeadlines) {
        this.startDeadlines = startDeadlines;
    }

    public List<Deadline> getEndDeadlines() {
        return this.endDeadlines;
    }

    public void setEndDeadlines(List<Deadline> endDeadlines) {
        this.endDeadlines = endDeadlines;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CollectionUtils.hashCode(this.endDeadlines);
        result = 31 * result + CollectionUtils.hashCode(this.startDeadlines);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeadlinesImpl)) {
            return false;
        }
        DeadlinesImpl other = (DeadlinesImpl)obj;
        return CollectionUtils.equals(this.endDeadlines, other.endDeadlines) && CollectionUtils.equals(this.startDeadlines, other.startDeadlines);
    }
}

