/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.commands;

import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import org.drools.command.Context;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.commands.CommandsUtil;
import org.jbpm.task.commands.TaskCommand;
import org.jbpm.task.commands.TaskContext;
import org.jbpm.task.events.AfterTaskForwardedEvent;
import org.jbpm.task.events.BeforeTaskForwardedEvent;
import org.jbpm.task.exception.PermissionDeniedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class ForwardTaskCommand<Void>
extends TaskCommand {
    public ForwardTaskCommand(long taskId, String userId, String targetEntityId) {
        this.taskId = taskId;
        this.userId = userId;
        this.targetEntityId = targetEntityId;
    }

    public Void execute(Context cntxt) {
        boolean ownerAllowed;
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        OrganizationalEntity targetEntity = context.getTaskIdentityService().getOrganizationalEntityById(this.targetEntityId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskForwardedEvent>(){}}).fire((Object)task);
        boolean adminAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators());
        boolean potOwnerAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getPotentialOwners());
        boolean bl = ownerAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        if (!(adminAllowed || potOwnerAllowed || ownerAllowed)) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        boolean noOp = true;
        if ((potOwnerAllowed || adminAllowed) && task.getTaskData().getStatus().equals((Object)Status.Ready)) {
            task.getTaskData().setStatus(Status.Ready);
            if (!task.getPeopleAssignments().getPotentialOwners().contains(targetEntity)) {
                task.getPeopleAssignments().getPotentialOwners().add(targetEntity);
            }
            task.getTaskData().setActualOwner(null);
            task.getPeopleAssignments().getPotentialOwners().remove(user);
            noOp = false;
        }
        if ((ownerAllowed || adminAllowed) && (task.getTaskData().getStatus().equals((Object)Status.Reserved) || task.getTaskData().getStatus().equals((Object)Status.InProgress))) {
            task.getTaskData().setStatus(Status.Ready);
            if (!task.getPeopleAssignments().getPotentialOwners().contains(targetEntity)) {
                task.getPeopleAssignments().getPotentialOwners().add(targetEntity);
            }
            task.getTaskData().setActualOwner(null);
            task.getPeopleAssignments().getPotentialOwners().remove(user);
            noOp = false;
        }
        if (noOp) {
            String errorMessage = "The action Forward Task on " + task.getId() + " was not applied by " + this.userId;
            throw new PermissionDeniedException(errorMessage);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskForwardedEvent>(){}}).fire((Object)task);
        return null;
    }
}

