/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.commands;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.util.AnnotationLiteral;
import org.drools.command.Context;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Content;
import org.jbpm.task.ContentData;
import org.jbpm.task.Task;
import org.jbpm.task.commands.TaskCommand;
import org.jbpm.task.commands.TaskContext;
import org.jbpm.task.events.AfterTaskAddedEvent;
import org.jbpm.task.events.BeforeTaskAddedEvent;
import org.jbpm.task.utils.ContentMarshallerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class AddTaskCommand<Long>
extends TaskCommand {
    private Task task;
    private Map<String, Object> params;
    private ContentData data;

    public AddTaskCommand(Task task, Map<String, Object> params) {
        this.task = task;
        this.params = params;
    }

    public AddTaskCommand(Task task, ContentData data) {
        this.task = task;
        this.data = data;
    }

    public Long execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskAddedEvent>(){}}).fire((Object)this.task);
        if (this.params != null) {
            ContentData contentData = ContentMarshallerHelper.marshal(this.params, null);
            Content content = new Content(contentData.getContent());
            context.getEm().persist((Object)content);
            this.task.getTaskData().setDocument(content.getId(), contentData);
        }
        if (this.data != null) {
            Content content = new Content(this.data.getContent());
            context.getEm().persist((Object)content);
            this.task.getTaskData().setDocument(content.getId(), this.data);
        }
        context.getEm().persist((Object)this.task);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskAddedEvent>(){}}).fire((Object)this.task);
        return (Long)this.task.getId();
    }

    public Task getTask() {
        return this.task;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public ContentData getData() {
        return this.data;
    }
}

