/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.commands;

import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import org.drools.command.Context;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.commands.CommandsUtil;
import org.jbpm.task.commands.TaskCommand;
import org.jbpm.task.commands.TaskContext;
import org.jbpm.task.events.AfterTaskClaimedEvent;
import org.jbpm.task.events.BeforeTaskClaimedEvent;
import org.jbpm.task.exception.PermissionDeniedException;

@Transactional
public class ClaimTaskCommand
extends TaskCommand {
    public ClaimTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskClaimedEvent>(){}}).fire((Object)task);
        boolean potOwnerAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getPotentialOwners());
        boolean adminAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators());
        if (!potOwnerAllowed && !adminAllowed) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.Ready)) {
            task.getTaskData().setStatus(Status.Reserved);
            task.getTaskData().setActualOwner(user);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskClaimedEvent>(){}}).fire((Object)task);
        return null;
    }
}

