/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.commands;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Content;
import org.jbpm.task.FaultData;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.commands.TaskCommand;
import org.jbpm.task.commands.TaskContext;
import org.jbpm.task.events.AfterTaskFailedEvent;
import org.jbpm.task.events.BeforeTaskFailedEvent;
import org.jbpm.task.exception.PermissionDeniedException;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.kie.command.Context;

@Transactional
public class FailTaskCommand<Void>
extends TaskCommand {
    private Map<String, Object> data;

    public FailTaskCommand(long taskId, String userId, Map<String, Object> data) {
        this.taskId = taskId;
        this.userId = userId;
        this.data = data;
    }

    public Void execute(Context cntxt) {
        boolean ownerAllowed;
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskFailedEvent>(){}}).fire((Object)task);
        boolean bl = ownerAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        if (!ownerAllowed) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.InProgress)) {
            task.getTaskData().setStatus(Status.Failed);
        }
        if (this.data != null) {
            FaultData faultData = ContentMarshallerHelper.marshalFault(this.data, null);
            Content content = new Content();
            content.setContent(faultData.getContent());
            context.getEm().persist((Object)content);
            task.getTaskData().setFault(content.getId(), faultData);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskFailedEvent>(){}}).fire((Object)task);
        return null;
    }
}

