/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.impl;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Group;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.User;
import org.jbpm.task.api.TaskIdentityService;

@Transactional
@ApplicationScoped
public class TaskIdentityServiceImpl
implements TaskIdentityService {
    @Inject
    private EntityManager em;

    @Override
    public void addUser(User user) {
        this.em.persist((Object)user);
    }

    @Override
    public void addGroup(Group group) {
        this.em.persist((Object)group);
    }

    @Override
    public void removeGroup(String groupId) {
        Group group = (Group)this.em.find(Group.class, (Object)groupId);
        this.em.remove((Object)group);
    }

    @Override
    public void removeUser(String userId) {
        User user = (User)this.em.find(User.class, (Object)userId);
        this.em.remove((Object)user);
    }

    @Override
    public List<User> getUsers() {
        return this.em.createQuery("from User").getResultList();
    }

    @Override
    public List<Group> getGroups() {
        return this.em.createQuery("from Group").getResultList();
    }

    @Override
    public User getUserById(String userId) {
        return (User)this.em.find(User.class, (Object)userId);
    }

    @Override
    public Group getGroupById(String groupId) {
        return (Group)this.em.find(Group.class, (Object)groupId);
    }

    @Override
    public OrganizationalEntity getOrganizationalEntityById(String entityId) {
        return (OrganizationalEntity)this.em.find(OrganizationalEntity.class, (Object)entityId);
    }
}

