/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.impl.factories;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jbpm.task.Group;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.TaskDef;
import org.jbpm.task.User;
import org.jbpm.task.exception.IllegalTaskStateException;
import org.jbpm.task.utils.MVELUtils;

public class TaskFactory {
    public static Task newTask(TaskDef taskDef) {
        Task task = new Task();
        TaskData taskData = new TaskData();
        taskData.initialize();
        task.setTaskData(taskData);
        TaskFactory.initializeTask(taskDef, task);
        return task;
    }

    public static void initializeTask(TaskDef taskDef, Task task) {
        if (task.getTaskData().getStatus() != Status.Created) {
            throw new IllegalTaskStateException("We can only initialize tasks in the Created Status!");
        }
        Status assignedStatus = null;
        if (assignedStatus != null) {
            task.getTaskData().setStatus(assignedStatus);
        }
    }

    public static void initializeTask(Task task) {
        if (task.getTaskData().getStatus() != Status.Created) {
            throw new IllegalTaskStateException("We can only initialize tasks in the Created Status!");
        }
        Status assignedStatus = null;
        if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getPotentialOwners() != null && task.getPeopleAssignments().getPotentialOwners().size() == 1) {
            OrganizationalEntity potentialOwner = task.getPeopleAssignments().getPotentialOwners().get(0);
            if (potentialOwner instanceof User) {
                task.getTaskData().setActualOwner((User)potentialOwner);
                assignedStatus = Status.Reserved;
            }
            if (potentialOwner instanceof Group) {
                assignedStatus = Status.Ready;
            }
        } else if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getPotentialOwners() != null && task.getPeopleAssignments().getPotentialOwners().size() > 1) {
            assignedStatus = Status.Ready;
        }
        if (assignedStatus != null) {
            task.getTaskData().setStatus(assignedStatus);
        }
        if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getBusinessAdministrators() != null) {
            ArrayList<OrganizationalEntity> businessAdmins = new ArrayList<OrganizationalEntity>();
            businessAdmins.add(new User("Administrator"));
            businessAdmins.addAll(task.getPeopleAssignments().getBusinessAdministrators());
            task.getPeopleAssignments().setBusinessAdministrators(businessAdmins);
        }
    }

    public static Task evalTask(Reader reader, Map<String, Object> vars, boolean initialize) {
        Task task = null;
        try {
            task = (Task)MVELUtils.eval(MVELUtils.toString(reader), vars);
            if (initialize) {
                TaskFactory.initializeTask(task);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TaskFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return task;
    }

    public static Task evalTask(String taskString, Map<String, Object> vars, boolean initialize) {
        Task task = (Task)MVELUtils.eval(taskString, vars);
        if (initialize) {
            TaskFactory.initializeTask(task);
        }
        return task;
    }

    public static Task evalTask(Reader reader) {
        return TaskFactory.evalTask(reader, null);
    }

    public static Task evalTask(Reader reader, Map<String, Object> vars) {
        return TaskFactory.evalTask(reader, vars, true);
    }
}

