/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import org.jbpm.task.EmailNotificationHeader;
import org.jbpm.task.Language;
import org.jbpm.task.Notification;
import org.jbpm.task.NotificationType;

@Entity
public class EmailNotification
extends Notification {
    @OneToMany(cascade={CascadeType.ALL})
    @MapKeyColumn(name="mapkey")
    private Map<Language, EmailNotificationHeader> emailHeaders;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.emailHeaders != null) {
            out.writeInt(this.emailHeaders.size());
            for (EmailNotificationHeader header : this.emailHeaders.values()) {
                header.writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int size = in.readInt();
        if (size > 0) {
            this.emailHeaders = new HashMap<Language, EmailNotificationHeader>(size);
            for (int i = 0; i < size; ++i) {
                EmailNotificationHeader header = new EmailNotificationHeader();
                header.readExternal(in);
                this.emailHeaders.put(new Language(header.getLanguage()), header);
            }
        }
    }

    @Override
    public NotificationType getNotificationType() {
        return NotificationType.Email;
    }

    public Map<Language, EmailNotificationHeader> getEmailHeaders() {
        return this.emailHeaders;
    }

    public void setEmailHeaders(Map<Language, EmailNotificationHeader> emailHeaders) {
        this.emailHeaders = emailHeaders;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.emailHeaders == null ? 0 : ((Object)this.emailHeaders).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EmailNotification)) {
            return false;
        }
        EmailNotification other = (EmailNotification)obj;
        return !(this.emailHeaders == null ? other.emailHeaders != null : !((Object)this.emailHeaders).equals(other.emailHeaders));
    }
}

