/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Version;
import org.jbpm.task.Deadlines;
import org.jbpm.task.Delegation;
import org.jbpm.task.I18NText;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.TaskData;
import org.jbpm.task.utils.CollectionUtils;

@Entity
public class Task
implements Externalizable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private int priority;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Task_Names_Id", nullable=true)
    private List<I18NText> names = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Task_Subjects_Id", nullable=true)
    private List<I18NText> subjects = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Task_Descriptions_Id", nullable=true)
    private List<I18NText> descriptions = Collections.emptyList();
    @Embedded
    private PeopleAssignments peopleAssignments;
    @Embedded
    private Delegation delegation;
    @Embedded
    private TaskData taskData;
    @Embedded
    private Deadlines deadlines;
    @Enumerated(value=EnumType.STRING)
    private SubTasksStrategy subTaskStrategy = SubTasksStrategy.NoAction;
    private String taskType;
    @Basic
    private Short archived = 0;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeInt(this.priority);
        out.writeShort(this.archived.shortValue());
        out.writeUTF(this.taskType);
        CollectionUtils.writeI18NTextList(this.names, out);
        CollectionUtils.writeI18NTextList(this.subjects, out);
        CollectionUtils.writeI18NTextList(this.descriptions, out);
        if (this.subTaskStrategy != null) {
            out.writeBoolean(true);
            out.writeUTF(this.subTaskStrategy.toString());
        } else {
            out.writeBoolean(false);
        }
        if (this.peopleAssignments != null) {
            out.writeBoolean(true);
            this.peopleAssignments.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.delegation != null) {
            out.writeBoolean(true);
            this.delegation.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.taskData != null) {
            out.writeBoolean(true);
            this.taskData.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.deadlines != null) {
            out.writeBoolean(true);
            this.deadlines.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.priority = in.readInt();
        this.archived = in.readShort();
        this.taskType = in.readUTF();
        this.names = CollectionUtils.readI18NTextList(in);
        this.subjects = CollectionUtils.readI18NTextList(in);
        this.descriptions = CollectionUtils.readI18NTextList(in);
        if (in.readBoolean()) {
            this.subTaskStrategy = SubTasksStrategy.valueOf(in.readUTF());
        }
        if (in.readBoolean()) {
            this.peopleAssignments = new PeopleAssignments();
            this.peopleAssignments.readExternal(in);
        }
        if (in.readBoolean()) {
            this.delegation = new Delegation();
            this.delegation.readExternal(in);
        }
        if (in.readBoolean()) {
            this.taskData = new TaskData();
            this.taskData.readExternal(in);
        }
        if (in.readBoolean()) {
            this.deadlines = new Deadlines();
            this.deadlines.readExternal(in);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Boolean isArchived() {
        if (this.archived == null) {
            return null;
        }
        return this.archived == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived == null ? null : (archived == true ? new Short("1") : new Short("0"));
    }

    public int getVersion() {
        return this.version;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List<I18NText> getNames() {
        return this.names;
    }

    public void setNames(List<I18NText> names) {
        this.names = names;
    }

    public List<I18NText> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<I18NText> subjects) {
        this.subjects = subjects;
    }

    public List<I18NText> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<I18NText> descriptions) {
        this.descriptions = descriptions;
    }

    public PeopleAssignments getPeopleAssignments() {
        return this.peopleAssignments;
    }

    public void setPeopleAssignments(PeopleAssignments peopleAssignments) {
        this.peopleAssignments = peopleAssignments;
    }

    public Delegation getDelegation() {
        return this.delegation;
    }

    public void setDelegation(Delegation delegation) {
        this.delegation = delegation;
    }

    public TaskData getTaskData() {
        return this.taskData;
    }

    public void setTaskData(TaskData taskData) {
        this.taskData = taskData;
    }

    public Deadlines getDeadlines() {
        return this.deadlines;
    }

    public void setDeadlines(Deadlines deadlines) {
        this.deadlines = deadlines;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public Short getArchived() {
        return this.archived;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.version;
        result = 31 * result + this.priority;
        result = 31 * result + this.archived.hashCode();
        result = 31 * result + (this.taskType == null ? 0 : this.taskType.hashCode());
        result = 31 * result + CollectionUtils.hashCode(this.descriptions);
        result = 31 * result + CollectionUtils.hashCode(this.names);
        result = 31 * result + CollectionUtils.hashCode(this.subjects);
        result = 31 * result + (this.peopleAssignments == null ? 0 : this.peopleAssignments.hashCode());
        result = 31 * result + (this.delegation == null ? 0 : this.delegation.hashCode());
        result = 31 * result + (this.taskData == null ? 0 : this.taskData.hashCode());
        result = 31 * result + (this.deadlines == null ? 0 : this.deadlines.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.archived != other.archived) {
            return false;
        }
        if (this.taskType == null ? other.taskType != null : !this.taskType.equals(other.taskType)) {
            return false;
        }
        if (this.deadlines == null) {
            if (other.deadlines != null) {
                // empty if block
            }
        } else if (!this.deadlines.equals(other.deadlines)) {
            return false;
        }
        if (this.delegation == null ? other.delegation != null : !this.delegation.equals(other.delegation)) {
            return false;
        }
        if (this.peopleAssignments == null ? other.peopleAssignments != null : !this.peopleAssignments.equals(other.peopleAssignments)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.taskData == null ? other.taskData != null : !this.taskData.equals(other.taskData)) {
            return false;
        }
        return CollectionUtils.equals(this.descriptions, other.descriptions) && CollectionUtils.equals(this.names, other.names) && CollectionUtils.equals(this.subjects, other.subjects);
    }

    public SubTasksStrategy getSubTaskStrategy() {
        return this.subTaskStrategy;
    }

    public void setSubTaskStrategy(SubTasksStrategy subTaskStrategy) {
        this.subTaskStrategy = subTaskStrategy;
    }
}

