/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.commands;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.commands.CommandsUtil;
import org.jbpm.task.commands.TaskCommand;
import org.jbpm.task.commands.TaskContext;
import org.jbpm.task.events.AfterTaskNominatedEvent;
import org.jbpm.task.events.BeforeTaskNominatedEvent;
import org.jbpm.task.exception.PermissionDeniedException;
import org.kie.command.Context;

@Transactional
public class NominateTaskCommand<Void>
extends TaskCommand {
    private List<OrganizationalEntity> potentialOwners;

    public NominateTaskCommand(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        this.taskId = taskId;
        this.userId = userId;
        this.potentialOwners = potentialOwners;
    }

    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskNominatedEvent>(){}}).fire((Object)task);
        if (CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators())) {
            task.getTaskData().assignOwnerAndStatus(this.potentialOwners);
            if (task.getTaskData().getStatus() == Status.Ready) {
                task.getPeopleAssignments().setPotentialOwners(this.potentialOwners);
            }
        } else {
            throw new PermissionDeniedException("User " + this.userId + " is not allowed to perform Nominate on Task " + this.taskId);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskNominatedEvent>(){}}).fire((Object)task);
        return null;
    }

    public List<OrganizationalEntity> getPotentialOwners() {
        return this.potentialOwners;
    }
}

