/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.drools.core.util.StringUtils;
import org.jbpm.task.Deadline;
import org.jbpm.task.Deadlines;
import org.jbpm.task.Escalation;
import org.jbpm.task.Group;
import org.jbpm.task.Notification;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.annotations.CommandBased;
import org.jbpm.task.api.TaskCommandExecutor;
import org.jbpm.task.commands.AddTaskCommand;
import org.jbpm.task.commands.NominateTaskCommand;
import org.jbpm.task.commands.TaskCommand;
import org.jbpm.task.exception.CannotAddTaskException;
import org.jbpm.task.identity.UserGroupCallback;

@Decorator
public class UserGroupTaskCommandExecutorDecorator
implements TaskCommandExecutor {
    @Inject
    @Delegate
    @CommandBased
    private TaskCommandExecutor executor;
    @Inject
    private EntityManager em;
    @Inject
    private UserGroupCallback userGroupCallback;
    private Map<String, Boolean> userGroupsMap = new HashMap<String, Boolean>();

    @Override
    public <T> T executeTaskCommand(TaskCommand<T> command) {
        if (command instanceof AddTaskCommand) {
            Task task = ((AddTaskCommand)command).getTask();
            this.doCallbackOperationForPeopleAssignments(task.getPeopleAssignments());
            this.doCallbackOperationForTaskData(task.getTaskData());
            this.doCallbackOperationForTaskDeadlines(task.getDeadlines());
        }
        if (command instanceof NominateTaskCommand) {
            List<OrganizationalEntity> potentialOwners = ((NominateTaskCommand)command).getPotentialOwners();
            this.doCallbackOperationForPotentialOwners(potentialOwners);
        }
        command.setGroupsIds(this.doUserGroupCallbackOperation(command.getUserId(), command.getGroupsIds()));
        this.doCallbackUserOperation(command.getTargetEntityId());
        return this.executor.executeTaskCommand(command);
    }

    private List<String> doUserGroupCallbackOperation(String userId, List<String> groupIds) {
        this.doCallbackUserOperation(userId);
        this.doCallbackGroupsOperation(userId, groupIds);
        List<String> allGroupIds = null;
        return this.userGroupCallback.getGroupsForUser(userId, groupIds, allGroupIds);
    }

    private boolean doCallbackUserOperation(String userId) {
        if (userId != null && this.userGroupCallback.existsUser(userId)) {
            this.addUserFromCallbackOperation(userId);
            return true;
        }
        return false;
    }

    private boolean doCallbackGroupOperation(String groupId) {
        if (groupId != null && this.userGroupCallback.existsGroup(groupId)) {
            this.addGroupFromCallbackOperation(groupId);
            return true;
        }
        return false;
    }

    private void addUserFromCallbackOperation(String userId) {
        try {
            boolean userExists;
            boolean bl = userExists = this.em.find(User.class, (Object)userId) != null;
            if (!StringUtils.isEmpty((CharSequence)userId) && !userExists) {
                User user = new User(userId);
                this.em.persist((Object)user);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void doCallbackGroupsOperation(String userId, List<String> groupIds) {
        block6: {
            block4: {
                List<String> userGroups;
                block5: {
                    if (userId == null) break block4;
                    if (groupIds == null || groupIds.size() <= 0) break block5;
                    List<String> userGroups2 = this.userGroupCallback.getGroupsForUser(userId, groupIds, null);
                    for (String groupId : groupIds) {
                        if (!this.userGroupCallback.existsGroup(groupId) || userGroups2 == null || !userGroups2.contains(groupId)) continue;
                        this.addGroupFromCallbackOperation(groupId);
                    }
                    break block6;
                }
                if (this.userGroupsMap.containsKey(userId) && this.userGroupsMap.get(userId).booleanValue() || (userGroups = this.userGroupCallback.getGroupsForUser(userId, null, null)) == null || userGroups.size() <= 0) break block6;
                for (String group : userGroups) {
                    this.addGroupFromCallbackOperation(group);
                }
                this.userGroupsMap.put(userId, true);
                break block6;
            }
            if (groupIds != null) {
                for (String groupId : groupIds) {
                    this.addGroupFromCallbackOperation(groupId);
                }
            }
        }
    }

    private void addGroupFromCallbackOperation(String groupId) {
        try {
            boolean groupExists;
            boolean bl = groupExists = this.em.find(Group.class, (Object)groupId) != null;
            if (!StringUtils.isEmpty((CharSequence)groupId) && !groupExists) {
                Group group = new Group(groupId);
                this.em.persist((Object)group);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void doCallbackOperationForTaskData(TaskData data) {
        boolean userExists;
        if (data.getActualOwner() != null && !(userExists = this.doCallbackUserOperation(data.getActualOwner().getId()))) {
            data.setActualOwner(null);
            data.setStatus(Status.Ready);
        }
        if (data.getCreatedBy() != null && !(userExists = this.doCallbackUserOperation(data.getCreatedBy().getId()))) {
            data.setCreatedBy(null);
        }
    }

    private void doCallbackOperationForPotentialOwners(List<OrganizationalEntity> potentialOwners) {
        ArrayList<OrganizationalEntity> nonExistingEntities = new ArrayList<OrganizationalEntity>();
        for (OrganizationalEntity orgEntity : potentialOwners) {
            boolean groupExists;
            boolean userExists;
            if (orgEntity instanceof User && !(userExists = this.doCallbackUserOperation(orgEntity.getId()))) {
                nonExistingEntities.add(orgEntity);
            }
            if (!(orgEntity instanceof Group) || (groupExists = this.doCallbackGroupOperation(orgEntity.getId()))) continue;
            nonExistingEntities.add(orgEntity);
        }
        if (!nonExistingEntities.isEmpty()) {
            potentialOwners.removeAll(nonExistingEntities);
        }
    }

    private void doCallbackOperationForPeopleAssignments(PeopleAssignments assignments) {
        ArrayList<OrganizationalEntity> nonExistingEntities = new ArrayList<OrganizationalEntity>();
        if (assignments != null) {
            List<OrganizationalEntity> stakeholders;
            List<OrganizationalEntity> recipients;
            List<OrganizationalEntity> excludedOwners;
            List<OrganizationalEntity> businessAdmins = assignments.getBusinessAdministrators();
            if (businessAdmins != null) {
                for (OrganizationalEntity admin : businessAdmins) {
                    boolean groupExists;
                    boolean userExists;
                    if (admin instanceof User && !(userExists = this.doCallbackUserOperation(admin.getId()))) {
                        nonExistingEntities.add(admin);
                    }
                    if (!(admin instanceof Group) || (groupExists = this.doCallbackGroupOperation(admin.getId()))) continue;
                    nonExistingEntities.add(admin);
                }
                if (!nonExistingEntities.isEmpty()) {
                    businessAdmins.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if (businessAdmins == null || businessAdmins.isEmpty()) {
                throw new CannotAddTaskException("There are no known Business Administrators, task cannot be created according to WS-HT specification");
            }
            List<OrganizationalEntity> potentialOwners = assignments.getPotentialOwners();
            if (potentialOwners != null) {
                for (OrganizationalEntity powner : potentialOwners) {
                    boolean groupExists;
                    boolean userExists;
                    if (powner instanceof User && !(userExists = this.doCallbackUserOperation(powner.getId()))) {
                        nonExistingEntities.add(powner);
                    }
                    if (!(powner instanceof Group) || (groupExists = this.doCallbackGroupOperation(powner.getId()))) continue;
                    nonExistingEntities.add(powner);
                }
                if (!nonExistingEntities.isEmpty()) {
                    potentialOwners.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if (assignments.getTaskInitiator() != null && assignments.getTaskInitiator().getId() != null) {
                this.doCallbackUserOperation(assignments.getTaskInitiator().getId());
            }
            if ((excludedOwners = assignments.getExcludedOwners()) != null) {
                for (OrganizationalEntity exowner : excludedOwners) {
                    boolean groupExists;
                    boolean userExists;
                    if (exowner instanceof User && !(userExists = this.doCallbackUserOperation(exowner.getId()))) {
                        nonExistingEntities.add(exowner);
                    }
                    if (!(exowner instanceof Group) || (groupExists = this.doCallbackGroupOperation(exowner.getId()))) continue;
                    nonExistingEntities.add(exowner);
                }
                if (!nonExistingEntities.isEmpty()) {
                    excludedOwners.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if ((recipients = assignments.getRecipients()) != null) {
                for (OrganizationalEntity recipient : recipients) {
                    boolean groupExists;
                    boolean userExists;
                    if (recipient instanceof User && !(userExists = this.doCallbackUserOperation(recipient.getId()))) {
                        nonExistingEntities.add(recipient);
                    }
                    if (!(recipient instanceof Group) || (groupExists = this.doCallbackGroupOperation(recipient.getId()))) continue;
                    nonExistingEntities.add(recipient);
                }
                if (!nonExistingEntities.isEmpty()) {
                    recipients.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if ((stakeholders = assignments.getTaskStakeholders()) != null) {
                for (OrganizationalEntity stakeholder : stakeholders) {
                    boolean groupExists;
                    boolean userExists;
                    if (stakeholder instanceof User && !(userExists = this.doCallbackUserOperation(stakeholder.getId()))) {
                        nonExistingEntities.add(stakeholder);
                    }
                    if (!(stakeholder instanceof Group) || (groupExists = this.doCallbackGroupOperation(stakeholder.getId()))) continue;
                    nonExistingEntities.add(stakeholder);
                }
                if (!nonExistingEntities.isEmpty()) {
                    stakeholders.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
        }
    }

    private void doCallbackOperationForTaskDeadlines(Deadlines deadlines) {
        if (deadlines != null) {
            List<OrganizationalEntity> potentialOwners;
            List<OrganizationalEntity> administrators;
            List<OrganizationalEntity> recipients;
            List<Reassignment> ressignments;
            List<Notification> notifications;
            List<Escalation> escalations;
            if (deadlines.getStartDeadlines() != null) {
                List<Deadline> startDeadlines = deadlines.getStartDeadlines();
                for (Deadline startDeadline : startDeadlines) {
                    escalations = startDeadline.getEscalations();
                    if (escalations == null) continue;
                    for (Escalation escalation : escalations) {
                        notifications = escalation.getNotifications();
                        ressignments = escalation.getReassignments();
                        if (notifications != null) {
                            for (Notification notification : notifications) {
                                recipients = notification.getRecipients();
                                if (recipients != null) {
                                    for (OrganizationalEntity recipient : recipients) {
                                        if (recipient instanceof User) {
                                            this.doCallbackUserOperation(recipient.getId());
                                        }
                                        if (!(recipient instanceof Group)) continue;
                                        this.doCallbackGroupOperation(recipient.getId());
                                    }
                                }
                                if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                                for (OrganizationalEntity administrator : administrators) {
                                    if (administrator instanceof User) {
                                        this.doCallbackUserOperation(administrator.getId());
                                    }
                                    if (!(administrator instanceof Group)) continue;
                                    this.doCallbackGroupOperation(administrator.getId());
                                }
                            }
                        }
                        if (ressignments == null) continue;
                        for (Reassignment reassignment : ressignments) {
                            potentialOwners = reassignment.getPotentialOwners();
                            if (potentialOwners == null) continue;
                            for (OrganizationalEntity potentialOwner : potentialOwners) {
                                if (potentialOwner instanceof User) {
                                    this.doCallbackUserOperation(potentialOwner.getId());
                                }
                                if (!(potentialOwner instanceof Group)) continue;
                                this.doCallbackGroupOperation(potentialOwner.getId());
                            }
                        }
                    }
                }
            }
            if (deadlines.getEndDeadlines() != null) {
                List<Deadline> endDeadlines = deadlines.getEndDeadlines();
                for (Deadline endDeadline : endDeadlines) {
                    escalations = endDeadline.getEscalations();
                    if (escalations == null) continue;
                    for (Escalation escalation : escalations) {
                        notifications = escalation.getNotifications();
                        ressignments = escalation.getReassignments();
                        if (notifications != null) {
                            for (Notification notification : notifications) {
                                recipients = notification.getRecipients();
                                if (recipients != null) {
                                    for (OrganizationalEntity recipient : recipients) {
                                        if (recipient instanceof User) {
                                            this.doCallbackUserOperation(recipient.getId());
                                        }
                                        if (!(recipient instanceof Group)) continue;
                                        this.doCallbackGroupOperation(recipient.getId());
                                    }
                                }
                                if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                                for (OrganizationalEntity administrator : administrators) {
                                    if (administrator instanceof User) {
                                        this.doCallbackUserOperation(administrator.getId());
                                    }
                                    if (!(administrator instanceof Group)) continue;
                                    this.doCallbackGroupOperation(administrator.getId());
                                }
                            }
                        }
                        if (ressignments == null) continue;
                        for (Reassignment reassignment : ressignments) {
                            potentialOwners = reassignment.getPotentialOwners();
                            if (potentialOwners == null) continue;
                            for (OrganizationalEntity potentialOwner : potentialOwners) {
                                if (potentialOwner instanceof User) {
                                    this.doCallbackUserOperation(potentialOwner.getId());
                                }
                                if (!(potentialOwner instanceof Group)) continue;
                                this.doCallbackGroupOperation(potentialOwner.getId());
                            }
                        }
                    }
                }
            }
        }
    }
}

