/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Content;
import org.jbpm.task.Deadline;
import org.jbpm.task.Escalation;
import org.jbpm.task.Notification;
import org.jbpm.task.NotificationType;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.api.TaskDeadlinesService;
import org.jbpm.task.events.NotificationEvent;

@Transactional
@ApplicationScoped
public class TaskDeadlinesServiceImpl
implements TaskDeadlinesService {
    private ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(3);
    private Map<Long, List<ScheduledFuture<ScheduledTaskDeadline>>> scheduledTaskDeadlines = new ConcurrentHashMap<Long, List<ScheduledFuture<ScheduledTaskDeadline>>>();
    protected List<Status> validStatuses = new ArrayList<Status>();
    @Inject
    private EntityManager em;
    @Inject
    private Event<NotificationEvent> notificationEvents;
    @Inject
    private Logger logger;

    @PostConstruct
    public void init() {
        this.setValidStatuses();
    }

    private void executeEscalatedDeadline(long taskId, long deadlineId) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        Deadline deadline = (Deadline)this.em.find(Deadline.class, (Object)deadlineId);
        TaskData taskData = task.getTaskData();
        Content content = null;
        if (taskData != null) {
            content = (Content)this.em.find(Content.class, (Object)taskData.getDocumentContentId());
        }
        if (deadline == null || deadline.getEscalations() == null || !this.isInValidStatus(task)) {
            return;
        }
        for (Escalation escalation : deadline.getEscalations()) {
            if (!escalation.getReassignments().isEmpty()) {
                Reassignment reassignment = escalation.getReassignments().get(0);
                task.getTaskData().setStatus(Status.Ready);
                ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>(reassignment.getPotentialOwners());
                task.getPeopleAssignments().setPotentialOwners(potentialOwners);
                task.getTaskData().setActualOwner(null);
            }
            for (Notification notification : escalation.getNotifications()) {
                if (notification.getNotificationType() != NotificationType.Email) continue;
                this.logger.log(Level.INFO, " ### Sending an Email");
                this.notificationEvents.fire((Object)new NotificationEvent(notification, task, content));
            }
        }
        deadline.setEscalated(true);
    }

    @Override
    public void schedule(long taskId, long deadlineId, long delay) {
        ScheduledFuture scheduled = this.scheduler.schedule(new ScheduledTaskDeadline(taskId, deadlineId), delay, TimeUnit.MILLISECONDS);
        List<ScheduledFuture<ScheduledTaskDeadline>> knownFutures = this.scheduledTaskDeadlines.get(taskId);
        if (knownFutures == null) {
            knownFutures = new CopyOnWriteArrayList<ScheduledFuture<ScheduledTaskDeadline>>();
        }
        knownFutures.add(scheduled);
        this.scheduledTaskDeadlines.put(taskId, knownFutures);
    }

    @Override
    public void unschedule(long taskId) {
        List<ScheduledFuture<ScheduledTaskDeadline>> knownFeatures = this.scheduledTaskDeadlines.remove(taskId);
        if (knownFeatures == null) {
            return;
        }
        for (ScheduledFuture<ScheduledTaskDeadline> scheduled : knownFeatures) {
            try {
                if (scheduled.isDone() || scheduled.isCancelled()) continue;
                scheduled.cancel(true);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, " XXX :Error while cancelling scheduled deadline task for Task with id " + taskId + " -> " + e);
            }
        }
    }

    protected void setValidStatuses() {
        this.validStatuses.add(Status.Created);
        this.validStatuses.add(Status.Ready);
        this.validStatuses.add(Status.Reserved);
        this.validStatuses.add(Status.InProgress);
        this.validStatuses.add(Status.Suspended);
    }

    protected boolean isInValidStatus(Task task) {
        return this.validStatuses.contains((Object)task.getTaskData().getStatus());
    }

    public class ScheduledTaskDeadline
    implements Callable {
        private long taskId;
        private long deadlineId;

        public ScheduledTaskDeadline(long taskId, long deadlineId) {
            this.taskId = taskId;
            this.deadlineId = deadlineId;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public long getDeadlineId() {
            return this.deadlineId;
        }

        public Object call() throws Exception {
            TaskDeadlinesServiceImpl.this.executeEscalatedDeadline(this.taskId, this.deadlineId);
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.deadlineId ^ this.deadlineId >>> 32);
            result = 31 * result + (int)(this.taskId ^ this.taskId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ScheduledTaskDeadline)) {
                return false;
            }
            ScheduledTaskDeadline other = (ScheduledTaskDeadline)obj;
            if (this.deadlineId != other.deadlineId) {
                return false;
            }
            return this.taskId == other.taskId;
        }
    }
}

