/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Attachment;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.ContentData;
import org.jbpm.task.FaultData;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.Task;
import org.jbpm.task.TaskDef;
import org.jbpm.task.TaskEvent;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.api.TaskAdminService;
import org.jbpm.task.api.TaskAttachmentService;
import org.jbpm.task.api.TaskCommentService;
import org.jbpm.task.api.TaskContentService;
import org.jbpm.task.api.TaskDefService;
import org.jbpm.task.api.TaskEventsService;
import org.jbpm.task.api.TaskIdentityService;
import org.jbpm.task.api.TaskInstanceService;
import org.jbpm.task.api.TaskQueryService;
import org.jbpm.task.api.TaskServiceEntryPoint;
import org.jbpm.task.api.TaskStatisticsService;
import org.jbpm.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.utils.ContentMarshallerHelper;

@Transactional
@ApplicationScoped
public class TaskServiceEntryPointImpl
implements TaskServiceEntryPoint {
    @Inject
    private TaskDefService taskDefService;
    @Inject
    private TaskInstanceService taskInstanceService;
    @Inject
    private TaskIdentityService taskIdentityService;
    @Inject
    private TaskAdminService taskAdminService;
    @Inject
    private TaskQueryService taskQueryService;
    @Inject
    private TaskEventsService taskEventsService;
    @Inject
    private TaskContentService taskContentService;
    @Inject
    private TaskCommentService taskCommentService;
    @Inject
    private TaskAttachmentService taskAttachmentService;
    @Inject
    private TaskStatisticsService taskStatisticService;
    @Inject
    private TaskLifeCycleEventListener taskLifeCycleEventListener;
    private UserInfo userInfo;

    @Override
    public TaskDefService getTaskDefService() {
        return this.taskDefService;
    }

    @Override
    public TaskInstanceService getTaskInstanceService() {
        return this.taskInstanceService;
    }

    @Override
    public TaskIdentityService getTaskIdentityService() {
        return this.taskIdentityService;
    }

    @Override
    public TaskAdminService getTaskAdminService() {
        return this.taskAdminService;
    }

    @Override
    public TaskQueryService getTaskQueryService() {
        return this.taskQueryService;
    }

    @Override
    public TaskEventsService getTaskEventsService() {
        return this.taskEventsService;
    }

    @Override
    public List<TaskSummary> getActiveTasks() {
        return this.taskAdminService.getActiveTasks();
    }

    @Override
    public List<TaskSummary> getActiveTasks(Date since) {
        return this.taskAdminService.getActiveTasks(since);
    }

    @Override
    public List<TaskSummary> getCompletedTasks() {
        return this.taskAdminService.getCompletedTasks();
    }

    @Override
    public List<TaskSummary> getCompletedTasks(Date since) {
        return this.taskAdminService.getCompletedTasks(since);
    }

    @Override
    public List<TaskSummary> getCompletedTasksByProcessId(Long processId) {
        return this.taskAdminService.getCompletedTasksByProcessId(processId);
    }

    @Override
    public int archiveTasks(List<TaskSummary> tasks) {
        return this.taskAdminService.archiveTasks(tasks);
    }

    @Override
    public List<TaskSummary> getArchivedTasks() {
        return this.taskAdminService.getArchivedTasks();
    }

    @Override
    public int removeTasks(List<TaskSummary> tasks) {
        return this.taskAdminService.removeTasks(tasks);
    }

    @Override
    public void deployTaskDef(TaskDef def) {
        this.taskDefService.deployTaskDef(def);
    }

    @Override
    public List<TaskDef> getAllTaskDef(String filter) {
        return this.taskDefService.getAllTaskDef(filter);
    }

    @Override
    public TaskDef getTaskDefById(String id) {
        return this.taskDefService.getTaskDefById(id);
    }

    @Override
    public void undeployTaskDef(String id) {
        this.taskDefService.undeployTaskDef(id);
    }

    @Override
    public void addUser(User user) {
        this.taskIdentityService.addUser(user);
    }

    @Override
    public void addGroup(Group group) {
        this.taskIdentityService.addGroup(group);
    }

    @Override
    public void removeGroup(String groupId) {
        this.taskIdentityService.removeGroup(groupId);
    }

    @Override
    public void removeUser(String userId) {
        this.taskIdentityService.removeUser(userId);
    }

    @Override
    public List<User> getUsers() {
        return this.taskIdentityService.getUsers();
    }

    @Override
    public List<Group> getGroups() {
        return this.taskIdentityService.getGroups();
    }

    @Override
    public User getUserById(String userId) {
        return this.taskIdentityService.getUserById(userId);
    }

    @Override
    public Group getGroupById(String groupId) {
        return this.taskIdentityService.getGroupById(groupId);
    }

    @Override
    public long newTask(String name, Map<String, Object> params) {
        return this.taskInstanceService.newTask(name, params);
    }

    @Override
    public void activate(long taskId, String userId) {
        this.taskInstanceService.activate(taskId, userId);
    }

    @Override
    public void claim(long taskId, String userId) {
        this.taskInstanceService.claim(taskId, userId);
    }

    @Override
    public void claim(long taskId, String userId, List<String> groupIds) {
        this.taskInstanceService.claim(taskId, userId, groupIds);
    }

    @Override
    public void claimNextAvailable(String userId, String language) {
        this.taskInstanceService.claimNextAvailable(userId, language);
    }

    @Override
    public void claimNextAvailable(String userId, List<String> groupIds, String language) {
        this.taskInstanceService.claimNextAvailable(userId, groupIds, language);
    }

    @Override
    public void complete(long taskId, String userId, Map<String, Object> data) {
        this.taskInstanceService.complete(taskId, userId, data);
    }

    @Override
    public void delegate(long taskId, String userId, String targetUserId) {
        this.taskInstanceService.delegate(taskId, userId, targetUserId);
    }

    @Override
    public void deleteFault(long taskId, String userId) {
        this.taskInstanceService.deleteFault(taskId, userId);
    }

    @Override
    public void deleteOutput(long taskId, String userId) {
        this.taskInstanceService.deleteOutput(taskId, userId);
    }

    @Override
    public void exit(long taskId, String userId) {
        this.taskInstanceService.exit(taskId, userId);
    }

    @Override
    public void fail(long taskId, String userId, Map<String, Object> faultData) {
        this.taskInstanceService.fail(taskId, userId, faultData);
    }

    @Override
    public void forward(long taskId, String userId, String targetEntityId) {
        this.taskInstanceService.forward(taskId, userId, targetEntityId);
    }

    @Override
    public void release(long taskId, String userId) {
        this.taskInstanceService.release(taskId, userId);
    }

    @Override
    public void remove(long taskId, String userId) {
        this.taskInstanceService.remove(taskId, userId);
    }

    @Override
    public void resume(long taskId, String userId) {
        this.taskInstanceService.resume(taskId, userId);
    }

    @Override
    public void setFault(long taskId, String userId, FaultData fault) {
        this.taskInstanceService.setFault(taskId, userId, fault);
    }

    @Override
    public void setOutput(long taskId, String userId, Object outputContentData) {
        this.taskInstanceService.setOutput(taskId, userId, outputContentData);
    }

    @Override
    public void setPriority(long taskId, int priority) {
        this.taskInstanceService.setPriority(taskId, priority);
    }

    @Override
    public void skip(long taskId, String userId) {
        this.taskInstanceService.skip(taskId, userId);
    }

    @Override
    public void start(long taskId, String userId) {
        this.taskInstanceService.start(taskId, userId);
    }

    @Override
    public void stop(long taskId, String userId) {
        this.taskInstanceService.stop(taskId, userId);
    }

    @Override
    public void suspend(long taskId, String userId) {
        this.taskInstanceService.suspend(taskId, userId);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        return this.taskQueryService.getTasksAssignedAsBusinessAdministrator(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        return this.taskQueryService.getTasksAssignedAsExcludedOwner(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        return this.taskQueryService.getTasksAssignedAsPotentialOwner(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language) {
        return this.taskQueryService.getTasksAssignedAsPotentialOwner(userId, groupIds, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResult) {
        return this.taskQueryService.getTasksAssignedAsPotentialOwner(userId, groupIds, language, firstResult, maxResult);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        return this.taskQueryService.getTasksAssignedAsRecipient(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        return this.taskQueryService.getTasksAssignedAsTaskInitiator(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        return this.taskQueryService.getTasksAssignedAsTaskStakeholder(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksOwned(String userId) {
        return this.taskQueryService.getTasksOwned(userId);
    }

    @Override
    public List<TaskSummary> getTasksOwned(String userId, List<Status> status, String language) {
        return this.taskQueryService.getTasksOwned(userId, status, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String salaboy, List<Status> status, String language) {
        return this.taskQueryService.getTasksAssignedAsPotentialOwnerByStatus(salaboy, status, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status, String language) {
        return this.taskQueryService.getTasksAssignedAsPotentialOwnerByStatusByGroup(userId, groupIds, status, language);
    }

    @Override
    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        return this.taskQueryService.getSubTasksAssignedAsPotentialOwner(parentId, userId, language);
    }

    @Override
    public List<TaskSummary> getSubTasksByParent(long parentId) {
        return this.taskQueryService.getSubTasksByParent(parentId);
    }

    @Override
    public Task getTaskById(long taskId) {
        return this.taskQueryService.getTaskInstanceById(taskId);
    }

    @Override
    public Task getTaskByWorkItemId(long workItemId) {
        return this.taskQueryService.getTaskByWorkItemId(workItemId);
    }

    @Override
    public List<TaskEvent> getTaskEventsById(long taskId) {
        return this.taskEventsService.getTaskEventsById(taskId);
    }

    @Override
    public long newTask(TaskDef def, Map<String, Object> params) {
        return this.taskInstanceService.newTask(def, params);
    }

    @Override
    public long newTask(TaskDef def, Map<String, Object> params, boolean deploy) {
        return this.taskInstanceService.newTask(def, params, deploy);
    }

    @Override
    public long addTask(Task task, Map<String, Object> params) {
        return this.taskInstanceService.addTask(task, params);
    }

    @Override
    public long addTask(Task task, ContentData data) {
        return this.taskInstanceService.addTask(task, data);
    }

    @Override
    public void setTaskDefService(TaskDefService taskDefService) {
        this.taskDefService = taskDefService;
    }

    @Override
    public void setTaskInstanceService(TaskInstanceService taskInstanceService) {
        this.taskInstanceService = taskInstanceService;
    }

    @Override
    public void setTaskIdentityService(TaskIdentityService taskIdentityService) {
        this.taskIdentityService = taskIdentityService;
    }

    @Override
    public void setTaskAdminService(TaskAdminService taskAdminService) {
        this.taskAdminService = taskAdminService;
    }

    @Override
    public void setTaskQueryService(TaskQueryService taskQueryService) {
        this.taskQueryService = taskQueryService;
    }

    @Override
    public void setTaskEventsService(TaskEventsService taskEventsService) {
        this.taskEventsService = taskEventsService;
    }

    @Override
    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public void addUsersAndGroups(Map<String, User> users, Map<String, Group> groups) {
        for (User user : users.values()) {
            this.getTaskIdentityService().addUser(user);
        }
        for (Group group : groups.values()) {
            this.getTaskIdentityService().addGroup(group);
        }
    }

    @Override
    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        this.taskInstanceService.nominate(taskId, userId, potentialOwners);
    }

    @Override
    public int removeAllTasks() {
        return this.taskAdminService.removeAllTasks();
    }

    @Override
    public long addContent(long taskId, Content content) {
        return this.taskContentService.addContent(taskId, content);
    }

    @Override
    public long addContent(long taskId, Map<String, Object> params) {
        return this.taskContentService.addContent(taskId, params);
    }

    @Override
    public void deleteContent(long taskId, long contentId) {
        this.taskContentService.deleteContent(taskId, contentId);
    }

    @Override
    public List<Content> getAllContentByTaskId(long taskId) {
        return this.taskContentService.getAllContentByTaskId(taskId);
    }

    @Override
    public Content getContentById(long contentId) {
        return this.taskContentService.getContentById(contentId);
    }

    @Override
    public long addAttachment(long taskId, Attachment attachment, Content content) {
        return this.taskAttachmentService.addAttachment(taskId, attachment, content);
    }

    @Override
    public void deleteAttachment(long taskId, long attachmentId) {
        this.taskAttachmentService.deleteAttachment(taskId, attachmentId);
    }

    @Override
    public List<Attachment> getAllAttachmentsByTaskId(long taskId) {
        return this.taskAttachmentService.getAllAttachmentsByTaskId(taskId);
    }

    @Override
    public Attachment getAttachmentById(long attachId) {
        return this.taskAttachmentService.getAttachmentById(attachId);
    }

    @Override
    public int getPendingSubTasksByParent(long parentId) {
        return this.taskQueryService.getPendingSubTasksByParent(parentId);
    }

    @Override
    public TaskLifeCycleEventListener getTaskLifeCycleEventListener() {
        return this.taskLifeCycleEventListener;
    }

    @Override
    public void removeTaskEventsById(long taskId) {
        this.taskEventsService.removeTaskEventsById(taskId);
    }

    @Override
    public OrganizationalEntity getOrganizationalEntityById(String entityId) {
        return this.taskIdentityService.getOrganizationalEntityById(entityId);
    }

    @Override
    public void setExpirationDate(long taskId, Date date) {
        this.taskInstanceService.setExpirationDate(taskId, date);
    }

    @Override
    public void setDescriptions(long taskId, List<I18NText> descriptions) {
        this.taskInstanceService.setDescriptions(taskId, descriptions);
    }

    @Override
    public void setSkipable(long taskId, boolean skipable) {
        this.taskInstanceService.setSkipable(taskId, skipable);
    }

    @Override
    public void setSubTaskStrategy(long taskId, SubTasksStrategy strategy) {
        this.taskInstanceService.setSubTaskStrategy(taskId, strategy);
    }

    @Override
    public int getPriority(long taskId) {
        return this.taskInstanceService.getPriority(taskId);
    }

    @Override
    public Date getExpirationDate(long taskId) {
        return this.taskInstanceService.getExpirationDate(taskId);
    }

    @Override
    public List<I18NText> getDescriptions(long taskId) {
        return this.taskInstanceService.getDescriptions(taskId);
    }

    @Override
    public boolean isSkipable(long taskId) {
        return this.taskInstanceService.isSkipable(taskId);
    }

    @Override
    public SubTasksStrategy getSubTaskStrategy(long taskId) {
        return this.taskInstanceService.getSubTaskStrategy(taskId);
    }

    @Override
    public Task getTaskInstanceById(long taskId) {
        return this.taskQueryService.getTaskInstanceById(taskId);
    }

    @Override
    public int getCompletedTaskByUserId(String userId) {
        return this.taskStatisticService.getCompletedTaskByUserId(userId);
    }

    @Override
    public int getPendingTaskByUserId(String userId) {
        return this.taskStatisticService.getPendingTaskByUserId(userId);
    }

    @Override
    public List<TaskSummary> getTasksAssignedByGroup(String groupId, String language) {
        return this.taskQueryService.getTasksAssignedByGroup(groupId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedByGroups(List<String> groupIds, String language) {
        return this.taskQueryService.getTasksAssignedByGroups(groupIds, language);
    }

    @Override
    public long addComment(long taskId, Comment comment) {
        return this.taskCommentService.addComment(taskId, comment);
    }

    @Override
    public void deleteComment(long taskId, long commentId) {
        this.taskCommentService.deleteComment(taskId, commentId);
    }

    @Override
    public List<Comment> getAllCommentsByTaskId(long taskId) {
        return this.taskCommentService.getAllCommentsByTaskId(taskId);
    }

    @Override
    public Comment getCommentById(long commentId) {
        return this.taskCommentService.getCommentById(commentId);
    }

    @Override
    public void setTaskNames(long taskId, List<I18NText> taskName) {
        this.taskInstanceService.setTaskNames(taskId, taskName);
    }

    @Override
    public Map<String, Object> getTaskContent(long taskId) {
        Task taskById = this.taskQueryService.getTaskInstanceById(taskId);
        Content contentById = this.taskContentService.getContentById(taskById.getTaskData().getDocumentContentId());
        Object unmarshalledObject = ContentMarshallerHelper.unmarshall(contentById.getContent(), null);
        if (!(unmarshalledObject instanceof Map)) {
            throw new IllegalStateException(" The Task Content Needs to be a Map in order to use this method and it was: " + unmarshalledObject.getClass());
        }
        Map content = (Map)unmarshalledObject;
        return content;
    }
}

