/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.impl;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Status;
import org.jbpm.task.api.TaskQueryService;
import org.jbpm.task.api.TaskStatisticsService;
import org.jbpm.task.query.TaskSummary;

@Transactional
@ApplicationScoped
public class TaskStatisticsServiceImpl
implements TaskStatisticsService {
    @Inject
    private TaskQueryService queryService;

    @Override
    public int getCompletedTaskByUserId(String userId) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Completed);
        List<TaskSummary> tasksCompleted = this.queryService.getTasksAssignedAsPotentialOwnerByStatus(userId, statuses, "en-UK");
        return tasksCompleted.size();
    }

    @Override
    public int getPendingTaskByUserId(String userId) {
        List<TaskSummary> tasksAssigned = this.queryService.getTasksAssignedAsPotentialOwner(userId, "en-UK");
        return tasksAssigned.size();
    }
}

