/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskAddedEvent;
import org.jbpm.services.task.events.BeforeTaskAddedEvent;
import org.jbpm.services.task.impl.model.ContentDataImpl;
import org.jbpm.services.task.impl.model.ContentImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.Task;

@Transactional
public class AddTaskCommand<Long>
extends TaskCommand {
    private Task task;
    private Map<String, Object> params;
    private ContentData data;

    public AddTaskCommand(Task task, Map<String, Object> params) {
        this.task = task;
        this.params = params;
    }

    public AddTaskCommand(Task task, ContentData data) {
        this.task = task;
        this.data = data;
    }

    public Long execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskAddedEvent>(){}}).fire((Object)this.task);
        if (this.params != null) {
            ContentDataImpl contentData = ContentMarshallerHelper.marshal(this.params, null);
            ContentImpl content = new ContentImpl(contentData.getContent());
            context.getPm().persist((Object)content);
            this.task.getTaskData().setDocument(content.getId(), (ContentData)contentData);
        }
        if (this.data != null) {
            ContentImpl content = new ContentImpl(this.data.getContent());
            context.getPm().persist((Object)content);
            this.task.getTaskData().setDocument(content.getId(), this.data);
        }
        context.getPm().persist((Object)this.task);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskAddedEvent>(){}}).fire((Object)this.task);
        return (Long)this.task.getId();
    }

    public Task getTask() {
        return this.task;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public ContentData getData() {
        return this.data;
    }
}

