/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.CommandsUtil;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskExitedEvent;
import org.jbpm.services.task.events.BeforeTaskExitedEvent;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.Status;
import org.kie.internal.task.api.model.Task;
import org.kie.internal.task.api.model.User;

@Transactional
public class ExitTaskCommand<Void>
extends TaskCommand {
    public ExitTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskExitedEvent>(){}}).fire((Object)task);
        boolean adminAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators());
        if (!adminAllowed) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.Created) || task.getTaskData().getStatus().equals((Object)Status.Ready) || task.getTaskData().getStatus().equals((Object)Status.Reserved) || task.getTaskData().getStatus().equals((Object)Status.InProgress) || task.getTaskData().getStatus().equals((Object)Status.Suspended)) {
            task.getTaskData().setStatus(Status.Exited);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskExitedEvent>(){}}).fire((Object)task);
        return null;
    }
}

