/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.util.List;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import org.jbpm.services.task.identity.AbstractUserGroupCallbackDecorator;
import org.kie.internal.task.api.TaskAttachmentService;
import org.kie.internal.task.api.model.Attachment;
import org.kie.internal.task.api.model.Content;

@Decorator
public class UserGroupTaskAttachmentDecorator
extends AbstractUserGroupCallbackDecorator
implements TaskAttachmentService {
    @Inject
    @Delegate
    private TaskAttachmentService attachmentService;

    public long addAttachment(long taskId, Attachment attachment, Content content) {
        this.doCallbackOperationForAttachment(attachment);
        long attachmentId = this.attachmentService.addAttachment(taskId, attachment, content);
        return attachmentId;
    }

    public void deleteAttachment(long taskId, long attachmentId) {
        this.attachmentService.deleteAttachment(taskId, attachmentId);
    }

    public List<Attachment> getAllAttachmentsByTaskId(long taskId) {
        return this.attachmentService.getAllAttachmentsByTaskId(taskId);
    }

    public Attachment getAttachmentById(long attachId) {
        return this.attachmentService.getAttachmentById(attachId);
    }

    private void doCallbackOperationForAttachment(Attachment attachment) {
        if (attachment != null && attachment.getAttachedBy() != null) {
            this.doCallbackUserOperation(attachment.getAttachedBy().getId());
        }
    }
}

