/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.util.List;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import org.jbpm.services.task.identity.AbstractUserGroupCallbackDecorator;
import org.kie.internal.task.api.TaskCommentService;
import org.kie.internal.task.api.model.Comment;

@Decorator
public class UserGroupTaskCommentDecorator
extends AbstractUserGroupCallbackDecorator
implements TaskCommentService {
    @Inject
    @Delegate
    private TaskCommentService commentService;

    public long addComment(long taskId, Comment comment) {
        this.doCallbackOperationForComment(comment);
        long commentId = this.commentService.addComment(taskId, comment);
        return commentId;
    }

    public void deleteComment(long taskId, long commentId) {
        this.commentService.deleteComment(taskId, commentId);
    }

    public List<Comment> getAllCommentsByTaskId(long taskId) {
        return this.commentService.getAllCommentsByTaskId(taskId);
    }

    public Comment getCommentById(long commentId) {
        return this.commentService.getCommentById(commentId);
    }

    private void doCallbackOperationForComment(Comment comment) {
        if (comment != null && comment.getAddedBy() != null) {
            this.doCallbackUserOperation(comment.getAddedBy().getId());
        }
    }
}

