/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.impl.model.CommentImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.internal.task.api.TaskCommentService;
import org.kie.internal.task.api.model.Comment;

@Transactional
@ApplicationScoped
public class TaskCommentServiceImpl
implements TaskCommentService {
    @Inject
    private JbpmServicesPersistenceManager pm;

    public long addComment(long taskId, Comment comment) {
        TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
        this.pm.persist((Object)comment);
        task.getTaskData().addComment(comment);
        return comment.getId();
    }

    public void deleteComment(long taskId, long commentId) {
        TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
        CommentImpl comment = (CommentImpl)this.pm.find(CommentImpl.class, (Object)commentId);
        task.getTaskData().removeComment(commentId);
        this.pm.remove((Object)comment);
    }

    public List<Comment> getAllCommentsByTaskId(long taskId) {
        TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
        return task.getTaskData().getComments();
    }

    public CommentImpl getCommentById(long commentId) {
        return (CommentImpl)this.pm.find(CommentImpl.class, (Object)commentId);
    }
}

