/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.OrganizationalEntityImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.internal.task.api.TaskIdentityService;
import org.kie.internal.task.api.model.Group;
import org.kie.internal.task.api.model.OrganizationalEntity;
import org.kie.internal.task.api.model.User;

@Transactional
@ApplicationScoped
public class TaskIdentityServiceImpl
implements TaskIdentityService {
    @Inject
    private JbpmServicesPersistenceManager pm;

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public void addUser(User user) {
        this.pm.persist((Object)user);
    }

    public void addGroup(Group group) {
        this.pm.persist((Object)group);
    }

    public void removeGroup(String groupId) {
        GroupImpl group = (GroupImpl)this.pm.find(GroupImpl.class, (Object)groupId);
        this.pm.remove((Object)group);
    }

    public void removeUser(String userId) {
        UserImpl user = (UserImpl)this.pm.find(UserImpl.class, (Object)userId);
        this.pm.remove((Object)user);
    }

    public List<User> getUsers() {
        return (List)this.pm.queryStringInTransaction("from User");
    }

    public List<Group> getGroups() {
        return (List)this.pm.queryStringInTransaction("from Group");
    }

    public User getUserById(String userId) {
        return (User)this.pm.find(UserImpl.class, (Object)userId);
    }

    public Group getGroupById(String groupId) {
        return (Group)this.pm.find(GroupImpl.class, (Object)groupId);
    }

    public OrganizationalEntity getOrganizationalEntityById(String entityId) {
        return (OrganizationalEntity)this.pm.find(OrganizationalEntityImpl.class, (Object)entityId);
    }
}

