/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.lifecycle.listeners;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.events.AfterTaskActivatedEvent;
import org.jbpm.services.task.events.AfterTaskAddedEvent;
import org.jbpm.services.task.events.AfterTaskClaimedEvent;
import org.jbpm.services.task.events.AfterTaskCompletedEvent;
import org.jbpm.services.task.events.AfterTaskExitedEvent;
import org.jbpm.services.task.events.AfterTaskFailedEvent;
import org.jbpm.services.task.events.AfterTaskStartedEvent;
import org.jbpm.services.task.events.AfterTaskStoppedEvent;
import org.jbpm.services.task.impl.model.BAMTaskSummaryImpl;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.internal.task.api.model.I18NText;
import org.kie.internal.task.api.model.Task;

@ApplicationScoped
@Transactional
@Alternative
public class BAMTaskEventListener
implements TaskLifeCycleEventListener {
    @Inject
    private JbpmServicesPersistenceManager pm;

    @Override
    public void afterTaskStartedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskStartedEvent Task ti) {
        List taskSummaries = (List)this.pm.queryStringWithParametersInTransaction("select bts from BAMTaskSummary bts where bts.taskId=:taskId", (Map)this.pm.addParametersToMap(new Object[]{"taskId", ti.getId()}));
        if (taskSummaries.isEmpty()) {
            String actualOwner = "";
            if (ti.getTaskData().getActualOwner() != null) {
                actualOwner = ti.getTaskData().getActualOwner().getId();
            }
            BAMTaskSummaryImpl bamTaskSummary = new BAMTaskSummaryImpl(ti.getId(), ((I18NText)ti.getNames().get(0)).getText(), "Started", new Date(), actualOwner, ti.getTaskData().getProcessInstanceId());
            bamTaskSummary.setStartDate(new Date());
            this.pm.persist((Object)bamTaskSummary);
        } else if (taskSummaries.size() == 1) {
            BAMTaskSummaryImpl taskSummaryById = (BAMTaskSummaryImpl)taskSummaries.get(0);
            taskSummaryById.setStatus("Started");
            taskSummaryById.setStartDate(new Date());
            if (ti.getTaskData().getActualOwner() != null) {
                taskSummaryById.setUserId(ti.getTaskData().getActualOwner().getId());
            }
            this.pm.merge((Object)taskSummaryById);
        } else {
            throw new IllegalStateException("We cannot have more than one BAM Task Summary for the task id = " + ti.getId());
        }
    }

    @Override
    public void afterTaskActivatedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskActivatedEvent Task ti) {
    }

    @Override
    public void afterTaskClaimedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskClaimedEvent Task ti) {
        List taskSummaries = (List)this.pm.queryStringWithParametersInTransaction("select bts from BAMTaskSummary bts where bts.taskId=:taskId", (Map)this.pm.addParametersToMap(new Object[]{"taskId", ti.getId()}));
        if (taskSummaries.isEmpty()) {
            String actualOwner = "";
            if (ti.getTaskData().getActualOwner() != null) {
                actualOwner = ti.getTaskData().getActualOwner().getId();
            }
            this.pm.persist((Object)new BAMTaskSummaryImpl(ti.getId(), ((I18NText)ti.getNames().get(0)).getText(), "Claimed", new Date(), actualOwner, ti.getTaskData().getProcessInstanceId()));
        } else if (taskSummaries.size() == 1) {
            BAMTaskSummaryImpl taskSummaryById = (BAMTaskSummaryImpl)taskSummaries.get(0);
            taskSummaryById.setStatus("Claimed");
            if (ti.getTaskData().getActualOwner() != null) {
                taskSummaryById.setUserId(ti.getTaskData().getActualOwner().getId());
            }
            this.pm.merge((Object)taskSummaryById);
        } else {
            throw new IllegalStateException("We cannot have more than one BAM Task Summary for the task id = " + ti.getId());
        }
    }

    @Override
    public void afterTaskSkippedEvent(Task ti) {
    }

    @Override
    public void afterTaskStoppedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskStoppedEvent Task ti) {
    }

    @Override
    public void afterTaskCompletedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskCompletedEvent Task ti) {
        List summaries = (List)this.pm.queryStringWithParametersInTransaction("select bts from BAMTaskSummary bts where bts.taskId=:taskId", (Map)this.pm.addParametersToMap(new Object[]{"taskId", ti.getId()}));
        if (summaries.size() == 1) {
            BAMTaskSummaryImpl taskSummaryById = (BAMTaskSummaryImpl)summaries.get(0);
            taskSummaryById.setStatus("Completed");
            Date completedDate = new Date();
            taskSummaryById.setEndDate(completedDate);
            taskSummaryById.setDuration(completedDate.getTime() - taskSummaryById.getStartDate().getTime());
            this.pm.merge((Object)taskSummaryById);
        } else {
            System.out.print("EEEE: Something went wrong with the Task BAM Listener");
        }
    }

    @Override
    public void afterTaskFailedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskFailedEvent Task ti) {
    }

    @Override
    public void afterTaskAddedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskAddedEvent Task ti) {
    }

    @Override
    public void afterTaskExitedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskExitedEvent Task ti) {
    }
}

