/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.utils;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.services.task.impl.model.AttachmentImpl;
import org.jbpm.services.task.impl.model.BooleanExpressionImpl;
import org.jbpm.services.task.impl.model.CommentImpl;
import org.jbpm.services.task.impl.model.DeadlineImpl;
import org.jbpm.services.task.impl.model.EmailNotificationImpl;
import org.jbpm.services.task.impl.model.EscalationImpl;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.impl.model.NotificationImpl;
import org.jbpm.services.task.impl.model.ReassignmentImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.kie.internal.task.api.model.Attachment;
import org.kie.internal.task.api.model.BooleanExpression;
import org.kie.internal.task.api.model.Comment;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.I18NText;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.NotificationType;
import org.kie.internal.task.api.model.OrganizationalEntity;
import org.kie.internal.task.api.model.Reassignment;
import org.kie.internal.task.api.model.User;

public class CollectionUtils {
    public static boolean equals(List list1, List list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            return true;
        }
        for (Object item1 : list1) {
            boolean exists = false;
            for (Object item2 : list2) {
                if (!item1.equals(item2)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(List list) {
        if (list == null) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        for (Object next : list) {
            result = 31 * result + (next == null ? 0 : next.hashCode());
        }
        return result;
    }

    public static void writeCommentList(List<Comment> list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (Comment item : list) {
            item.writeExternal(out);
        }
    }

    public static List<Comment> readCommentList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<Comment> list = new ArrayList<Comment>(size);
        for (int i = 0; i < size; ++i) {
            CommentImpl item = new CommentImpl();
            item.readExternal(in);
            list.add(item);
        }
        return list;
    }

    public static void writeAttachmentList(List<Attachment> list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (Attachment item : list) {
            item.writeExternal(out);
        }
    }

    public static List<Attachment> readAttachmentList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<Attachment> list = new ArrayList<Attachment>(size);
        for (int i = 0; i < size; ++i) {
            AttachmentImpl item = new AttachmentImpl();
            item.readExternal(in);
            list.add(item);
        }
        return list;
    }

    public static void writeBooleanExpressionList(List<BooleanExpression> list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (BooleanExpression item : list) {
            item.writeExternal(out);
        }
    }

    public static List<BooleanExpression> readBooleanExpressionList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>(size);
        for (int i = 0; i < size; ++i) {
            BooleanExpressionImpl item = new BooleanExpressionImpl();
            item.readExternal(in);
            list.add(item);
        }
        return list;
    }

    public static void writeNotificationList(List<Notification> list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (Notification item : list) {
            out.writeUTF(item.getNotificationType().toString());
            item.writeExternal(out);
        }
    }

    public static List<Notification> readNotificationList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<Notification> list = new ArrayList<Notification>(size);
        for (int i = 0; i < size; ++i) {
            NotificationImpl item = null;
            switch (NotificationType.valueOf((String)in.readUTF())) {
                case Default: {
                    item = new NotificationImpl();
                    break;
                }
                case Email: {
                    item = new EmailNotificationImpl();
                }
            }
            item.readExternal(in);
            list.add(item);
        }
        return list;
    }

    public static void writeReassignmentList(List<Reassignment> list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (Reassignment item : list) {
            item.writeExternal(out);
        }
    }

    public static List<Reassignment> readReassignmentList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<Reassignment> list = new ArrayList<Reassignment>(size);
        for (int i = 0; i < size; ++i) {
            ReassignmentImpl item = new ReassignmentImpl();
            item.readExternal(in);
            list.add(item);
        }
        return list;
    }

    public static void writeDeadlineList(List<Deadline> list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (Deadline item : list) {
            item.writeExternal(out);
        }
    }

    public static List<Deadline> readDeadlinesList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<Deadline> list = new ArrayList<Deadline>(size);
        for (int i = 0; i < size; ++i) {
            DeadlineImpl item = new DeadlineImpl();
            item.readExternal(in);
            list.add(item);
        }
        return list;
    }

    public static void writeEscalationList(List<Escalation> list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (Escalation item : list) {
            item.writeExternal(out);
        }
    }

    public static List<Escalation> readEscalationList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<Escalation> list = new ArrayList<Escalation>(size);
        for (int i = 0; i < size; ++i) {
            EscalationImpl item = new EscalationImpl();
            item.readExternal(in);
            list.add(item);
        }
        return list;
    }

    public static void writeI18NTextList(List<I18NText> list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (I18NText item : list) {
            item.writeExternal(out);
        }
    }

    public static List<I18NText> readI18NTextList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<I18NText> list = new ArrayList<I18NText>(size);
        for (int i = 0; i < size; ++i) {
            I18NTextImpl item = new I18NTextImpl();
            item.readExternal(in);
            list.add(item);
        }
        return list;
    }

    public static void writeOrganizationalEntityList(List<OrganizationalEntity> list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (OrganizationalEntity item : list) {
            if (item instanceof User) {
                out.writeShort(0);
            } else {
                out.writeShort(1);
            }
            item.writeExternal(out);
        }
    }

    public static List<OrganizationalEntity> readOrganizationalEntityList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<OrganizationalEntity> list = new ArrayList<OrganizationalEntity>(size);
        for (int i = 0; i < size; ++i) {
            short type = in.readShort();
            if (type == 0) {
                UserImpl user = new UserImpl();
                user.readExternal(in);
                list.add(user);
                continue;
            }
            GroupImpl group = new GroupImpl();
            group.readExternal(in);
            list.add(group);
        }
        return list;
    }
}

