/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.CommandsUtil;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskStartedEvent;
import org.jbpm.services.task.events.BeforeTaskStartedEvent;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.InternalTaskData;

@Transactional
public class StartTaskCommand
extends TaskCommand<Void> {
    public StartTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskStartedEvent>(){}}).fire((Object)task);
        boolean operationAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getPotentialOwners());
        if (!operationAllowed) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.Ready)) {
            ((InternalTaskData)task.getTaskData()).setStatus(Status.InProgress);
            ((InternalTaskData)task.getTaskData()).setActualOwner(user);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.Reserved)) {
            ((InternalTaskData)task.getTaskData()).setStatus(Status.InProgress);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskStartedEvent>(){}}).fire((Object)task);
        return null;
    }
}

