/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.impl.model.OrganizationalEntityImpl;
import org.jbpm.services.task.utils.CollectionUtils;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.task.api.model.Reassignment;

@Entity
@Table(name="Reassignment")
@SequenceGenerator(name="reassignmentIdSeq", sequenceName="REASSIGNMENT_ID_SEQ", allocationSize=1)
public class ReassignmentImpl
implements Reassignment {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="reassignmentIdSeq")
    private long id;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=I18NTextImpl.class)
    @JoinColumn(name="Reassignment_Documentation_Id", nullable=true)
    private List<I18NText> documentation = Collections.emptyList();
    @ManyToMany(targetEntity=OrganizationalEntityImpl.class)
    @JoinTable(name="Reassignment_potentialOwners", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")})
    private List<OrganizationalEntity> potentialOwners = Collections.emptyList();

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        CollectionUtils.writeI18NTextList(this.documentation, out);
        CollectionUtils.writeOrganizationalEntityList(this.potentialOwners, out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.documentation = CollectionUtils.readI18NTextList(in);
        this.potentialOwners = CollectionUtils.readOrganizationalEntityList(in);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public List<I18NText> getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(List<I18NText> documentation) {
        this.documentation = documentation;
    }

    public List<OrganizationalEntity> getPotentialOwners() {
        return this.potentialOwners;
    }

    public void setPotentialOwners(List<OrganizationalEntity> potentialOwners) {
        this.potentialOwners = potentialOwners;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CollectionUtils.hashCode(this.documentation);
        result = 31 * result + CollectionUtils.hashCode(this.potentialOwners);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReassignmentImpl)) {
            return false;
        }
        ReassignmentImpl other = (ReassignmentImpl)obj;
        return CollectionUtils.equals(this.documentation, other.documentation) && CollectionUtils.equals(this.potentialOwners, other.potentialOwners);
    }
}

