/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.lifecycle.listeners;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.events.AfterTaskActivatedEvent;
import org.jbpm.services.task.events.AfterTaskAddedEvent;
import org.jbpm.services.task.events.AfterTaskClaimedEvent;
import org.jbpm.services.task.events.AfterTaskCompletedEvent;
import org.jbpm.services.task.events.AfterTaskExitedEvent;
import org.jbpm.services.task.events.AfterTaskFailedEvent;
import org.jbpm.services.task.events.AfterTaskStartedEvent;
import org.jbpm.services.task.events.AfterTaskStoppedEvent;
import org.jbpm.services.task.impl.model.TaskEventImpl;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.model.TaskEvent;

@Alternative
@ApplicationScoped
public class JPATaskLifeCycleEventListener
implements TaskLifeCycleEventListener {
    @Inject
    private JbpmServicesPersistenceManager pm;

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    @Override
    @Transactional
    public void afterTaskStartedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskStartedEvent Task ti) {
        this.pm.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.STARTED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskActivatedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskActivatedEvent Task ti) {
        this.pm.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.ACTIVATED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskClaimedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskClaimedEvent Task ti) {
        this.pm.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.CLAIMED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskSkippedEvent(Task ti) {
        this.pm.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.SKIPPED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskStoppedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskStoppedEvent Task ti) {
        this.pm.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.STOPPED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskCompletedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskCompletedEvent Task ti) {
        this.pm.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.COMPLETED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskFailedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskFailedEvent Task ti) {
        this.pm.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.FAILED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskAddedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskAddedEvent Task ti) {
        this.pm.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.ADDED, ti.getTaskData().getActualOwner()));
    }

    @Override
    public void afterTaskExitedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskExitedEvent Task ti) {
        this.pm.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.EXITED, ti.getTaskData().getActualOwner()));
    }
}

